/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.security.authentication.LoginContextProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak AuthenticationConfiguration")
@Service(value={AuthenticationConfiguration.class, SecurityConfiguration.class})
@Properties(value={@Property(name="org.apache.jackrabbit.oak.authentication.appName", label="Application Name", value={"jackrabbit.oak"}, description="Application named used for JAAS authentication"), @Property(name="org.apache.jackrabbit.oak.authentication.configSpiName", label="JAAS Config SPI Name", description="Name of JAAS Configuration Spi. This needs to be set to JAAS config provider name if JAAS authentication is managed by Felix JAAS Support with its Global Configuration Policy set to 'default'.")})
public class AuthenticationConfigurationImpl
extends ConfigurationBase
implements AuthenticationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConfigurationImpl.class);

    public AuthenticationConfigurationImpl() {
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    public AuthenticationConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication"));
    }

    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication";
    }

    @Nonnull
    public LoginContextProvider getLoginContextProvider(ContentRepository contentRepository) {
        String appName = (String)this.getParameters().getConfigValue("org.apache.jackrabbit.oak.authentication.appName", (Object)"jackrabbit.oak");
        SecurityProvider provider = this.getSecurityProvider();
        Whiteboard whiteboard = null;
        if (provider instanceof WhiteboardAware) {
            whiteboard = ((WhiteboardAware)provider).getWhiteboard();
        } else {
            log.warn("Unable to obtain whiteboard from SecurityProvider");
        }
        return new LoginContextProviderImpl(appName, this.getParameters(), contentRepository, this.getSecurityProvider(), whiteboard);
    }
}

