/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.util.Dictionary;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.security.authentication.CustomLoginModule;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Custom Test Login Module (Oak Exercise Module)", metatype=true, policy=ConfigurationPolicy.REQUIRE, configurationFactory=true)
@Service
public class CustomLoginModuleFactory
implements LoginModuleFactory {
    private static final Logger log = LoggerFactory.getLogger(CustomLoginModuleFactory.class);
    @Property(intValue={500}, label="JAAS Ranking", description="Specifying the ranking (i.e. sort order) of this login module entry. The entries are sorted in a descending order (i.e. higher value ranked configurations come first).")
    public static final String JAAS_RANKING = "jaas.ranking";
    @Property(value={"OPTIONAL"}, label="JAAS Control Flag", description="Property specifying whether or not a LoginModule is REQUIRED, REQUISITE, SUFFICIENT or OPTIONAL. Refer to the JAAS configuration documentation for more details around the meaning of these flags.")
    public static final String JAAS_CONTROL_FLAG = "jaas.controlFlag";
    @Property(label="JAAS Realm", description="The realm name (or application name) against which the LoginModule  is be registered. If no realm name is provided then LoginModule is registered with a default realm as configured in the Felix JAAS configuration.")
    public static final String JAAS_REALM_NAME = "jaas.realmName";
    private ConfigurationParameters osgiConfig;

    @Activate
    private void activate(ComponentContext componentContext) {
        this.osgiConfig = ConfigurationParameters.of((Dictionary)componentContext.getProperties());
    }

    @Deactivate
    private void deactivate() {
    }

    public LoginModule createLoginModule() {
        return new CustomLoginModule(this.osgiConfig);
    }
}

