/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.security.authentication.user.LoginModuleImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.GuestLoginModule;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.junit.Assert;
import org.junit.Test;

public class GuestDefaultLoginModuleTest
extends AbstractSecurityTest {
    protected Configuration getConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                AppConfigurationEntry guestEntry = new AppConfigurationEntry(GuestLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, Collections.emptyMap());
                AppConfigurationEntry defaultEntry = new AppConfigurationEntry(LoginModuleImpl.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap());
                return new AppConfigurationEntry[]{guestEntry, defaultEntry};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullLogin() throws Exception {
        ContentSession cs = this.login(null);
        try {
            AuthInfo authInfo = cs.getAuthInfo();
            String anonymousID = UserUtil.getAnonymousId((ConfigurationParameters)this.getUserConfiguration().getParameters());
            Assert.assertEquals((Object)anonymousID, (Object)authInfo.getUserID());
        }
        finally {
            cs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuestLogin() throws Exception {
        ContentSession cs = this.login((Credentials)new GuestCredentials());
        try {
            AuthInfo authInfo = cs.getAuthInfo();
            String anonymousID = UserUtil.getAnonymousId((ConfigurationParameters)this.getUserConfiguration().getParameters());
            Assert.assertEquals((Object)anonymousID, (Object)authInfo.getUserID());
        }
        finally {
            cs.close();
        }
    }
}

