/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenLoginModule;
import org.apache.jackrabbit.oak.security.authentication.user.LoginModuleImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.junit.Assert;
import org.junit.Test;

public class TokenDefaultLoginModuleTest
extends AbstractSecurityTest {
    protected Configuration getConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                AppConfigurationEntry tokenEntry = new AppConfigurationEntry(TokenLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, Collections.emptyMap());
                AppConfigurationEntry defaultEntry = new AppConfigurationEntry(LoginModuleImpl.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap());
                return new AppConfigurationEntry[]{tokenEntry, defaultEntry};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullLogin() throws Exception {
        ContentSession cs = null;
        try {
            cs = this.login(null);
            Assert.fail((String)"Null login should fail");
        }
        catch (LoginException loginException) {
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGuestLogin() throws Exception {
        ContentSession cs = null;
        try {
            cs = this.login((Credentials)new GuestCredentials());
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSimpleCredentials() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = new SimpleCredentials("test", new char[0]);
            cs = this.login((Credentials)sc);
            Assert.fail((String)"Invalid simple credentials login should fail");
        }
        catch (LoginException loginException) {
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSimpleCredentialsWithAttribute() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = new SimpleCredentials("test", new char[0]);
            sc.setAttribute(".token", (Object)"");
            cs = this.login((Credentials)sc);
            Assert.fail((String)"Invalid simple credentials login should fail");
        }
        catch (LoginException loginException) {
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleCredentials() throws Exception {
        ContentSession cs = null;
        try {
            cs = this.login(this.getAdminCredentials());
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleCredentialsWithAttribute() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            cs = this.login((Credentials)sc);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenAuthInfo() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            cs = this.login((Credentials)sc);
            Assert.assertEquals((String)"userid must be correct", (Object)"admin", (Object)cs.getAuthInfo().getUserID());
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenCreationAndLogin() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            cs = this.login((Credentials)sc);
            String token = sc.getAttribute(".token").toString();
            Assert.assertNotNull((Object)token);
            TokenCredentials tc = new TokenCredentials(token.toString());
            cs.close();
            cs = this.login((Credentials)tc);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenCreationAndImpersonation() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            ImpersonationCredentials ic = new ImpersonationCredentials((Credentials)sc, (AuthInfo)new AuthInfoImpl(((SimpleCredentials)this.getAdminCredentials()).getUserID(), Collections.emptyMap(), Collections.emptySet()));
            cs = this.login((Credentials)ic);
            String token = sc.getAttribute(".token").toString();
            Assert.assertNotNull((Object)token);
            TokenCredentials tc = new TokenCredentials(token.toString());
            cs.close();
            cs = this.login((Credentials)tc);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidTokenCredentials() throws Exception {
        ContentSession cs = null;
        try {
            cs = this.login((Credentials)new TokenCredentials("invalid"));
            Assert.fail((String)"Invalid token credentials login should fail");
        }
        catch (LoginException loginException) {
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidTokenCredentials() throws Exception {
        Root root = this.adminSession.getLatestRoot();
        TokenConfiguration tc = (TokenConfiguration)this.getSecurityProvider().getConfiguration(TokenConfiguration.class);
        TokenProvider tp = tc.getTokenProvider(root);
        SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
        TokenInfo info = tp.createToken(sc.getUserID(), Collections.emptyMap());
        ContentSession cs = this.login((Credentials)new TokenCredentials(info.getToken()));
        try {
            Assert.assertEquals((Object)sc.getUserID(), (Object)cs.getAuthInfo().getUserID());
        }
        finally {
            cs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenCreationWithAttributes() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            sc.setAttribute(".token.mandatory", (Object)"something");
            sc.setAttribute("attr", (Object)"val");
            cs = this.login((Credentials)sc);
            AuthInfo ai = cs.getAuthInfo();
            ImmutableSet attrNames = ImmutableSet.copyOf((Object[])ai.getAttributeNames());
            Assert.assertTrue((boolean)attrNames.contains("attr"));
            Assert.assertFalse((boolean)attrNames.contains(".token"));
            Assert.assertFalse((boolean)attrNames.contains(".token.mandatory"));
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenCreationWithImpersonationAttributes() throws Exception {
        ContentSession cs = null;
        try {
            SimpleCredentials sc = (SimpleCredentials)this.getAdminCredentials();
            sc.setAttribute(".token", (Object)"");
            sc.setAttribute(".token.mandatory", (Object)"something");
            sc.setAttribute("attr", (Object)"val");
            ImpersonationCredentials ic = new ImpersonationCredentials((Credentials)sc, (AuthInfo)new AuthInfoImpl(((SimpleCredentials)this.getAdminCredentials()).getUserID(), Collections.emptyMap(), Collections.emptySet()));
            cs = this.login((Credentials)ic);
            AuthInfo ai = cs.getAuthInfo();
            ImmutableSet attrNames = ImmutableSet.copyOf((Object[])ai.getAttributeNames());
            Assert.assertTrue((boolean)attrNames.contains("attr"));
            Assert.assertFalse((boolean)attrNames.contains(".token"));
            Assert.assertFalse((boolean)attrNames.contains(".token.mandatory"));
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenLoginForDisabledUser() throws Exception {
        ContentSession cs = null;
        try {
            User user = this.getTestUser();
            SimpleCredentials sc = new SimpleCredentials(user.getID(), user.getID().toCharArray());
            sc.setAttribute(".token", (Object)"");
            cs = this.login((Credentials)sc);
            user.disable("disabled");
            this.root.commit();
            String token = sc.getAttribute(".token").toString();
            Assert.assertNotNull((Object)token);
            TokenCredentials tc = new TokenCredentials(token.toString());
            cs.close();
            cs = this.login((Credentials)tc);
            Assert.fail((String)"token login for a disabled user must fail.");
        }
        catch (LoginException loginException) {
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }
}

