/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AbstractRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.value.StringValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomRestrictionProviderTest
extends AbstractSecurityTest {
    private static final String TEST_ROOT_PATH = "/testRoot";
    private static final String TEST_A_PATH = "/testRoot/a";
    private static final String TEST_B_PATH = "/testRoot/a/b";
    private static final String TEST_C_PATH = "/testRoot/a/b/c";
    private static final String TEST_D_PATH = "/testRoot/a/b/c/d";
    private static final String TEST_E_PATH = "/testRoot/a/b/c/d/e";
    private static final String PROP_NAME_PROTECT_ME = "protect-me";
    private Principal testPrincipal;

    protected ConfigurationParameters getSecurityConfigParameters() {
        RestrictionProvider rProvider = CompositeRestrictionProvider.newInstance((RestrictionProvider[])new RestrictionProvider[]{new PropertyRestrictionProvider(), new RestrictionProviderImpl()});
        ImmutableMap authorizMap = ImmutableMap.of((Object)"restrictionProvider", (Object)rProvider);
        return ConfigurationParameters.of((Map)ImmutableMap.of((Object)"org.apache.jackrabbit.oak.authorization", (Object)ConfigurationParameters.of((Map)authorizMap)));
    }

    @Before
    public void before() throws Exception {
        super.before();
        NodeUtil rootNode = new NodeUtil(this.root.getTree("/"));
        NodeUtil testRootNode = rootNode.addChild("testRoot", "nt:unstructured");
        NodeUtil a = testRootNode.addChild("a", "nt:unstructured");
        NodeUtil b = a.addChild("b", "nt:unstructured");
        NodeUtil c = b.addChild("c", "nt:unstructured");
        c.setBoolean(PROP_NAME_PROTECT_ME, true);
        NodeUtil d = c.addChild("d", "nt:unstructured");
        d.addChild("e", "nt:unstructured");
        this.root.commit();
        this.testPrincipal = this.getTestUser().getPrincipal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() throws Exception {
        try {
            this.root.refresh();
            this.root.getTree(TEST_ROOT_PATH).remove();
            this.root.commit();
        }
        finally {
            super.after();
        }
    }

    private void addEntry(String path, boolean grant, String restriction, String ... privilegeNames) throws Exception {
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
        if (restriction.length() > 0) {
            HashMap<String, StringValue> rs = new HashMap<String, StringValue>();
            rs.put("hasProperty", new StringValue(restriction));
            acl.addEntry(this.testPrincipal, AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privilegeNames), grant, rs);
        } else {
            acl.addEntry(this.testPrincipal, AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privilegeNames), grant);
        }
        acMgr.setPolicy(path, (AccessControlPolicy)acl);
        this.root.commit();
    }

    private void assertIsGranted(PermissionProvider pp, Root root, boolean allow, String path, long permissions) {
        Assert.assertEquals((String)("user should " + (allow ? "" : "not ") + "have " + permissions + " on " + path), (Object)allow, (Object)pp.isGranted(root.getTree(path), null, permissions));
    }

    private PermissionProvider getPermissionProvider(ContentSession session) {
        return ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getPermissionProvider(this.root, session.getWorkspaceName(), session.getAuthInfo().getPrincipals());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectByRestriction() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_A_PATH, false, PROP_NAME_PROTECT_ME, "jcr:removeNode");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 64L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_E_PATH, 64L);
            testRoot.getTree(TEST_D_PATH).remove();
            testRoot.commit();
            try {
                testRoot.getTree(TEST_C_PATH).remove();
                testRoot.commit();
                Assert.fail((String)"should not be able to delete /testRoot/a/b/c");
            }
            catch (CommitFailedException e) {
                // empty catch block
            }
        }
        finally {
            testSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectPropertiesByRestriction() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_A_PATH, false, PROP_NAME_PROTECT_ME, "jcr:modifyProperties");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 8L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_E_PATH, 8L);
        }
        finally {
            testSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnProtectByRestriction() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_ROOT_PATH, false, "", "jcr:removeNode");
        this.addEntry(TEST_A_PATH, true, "!protect-me", "jcr:removeNode");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 64L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_E_PATH, 64L);
        }
        finally {
            testSession.close();
        }
    }

    public static class HasPropertyPattern
    implements RestrictionPattern {
        private final String propertyName;
        private final boolean negate;

        private HasPropertyPattern(@Nonnull String propertyName) {
            if (propertyName.startsWith("!")) {
                this.propertyName = propertyName.substring(1);
                this.negate = true;
            } else {
                this.propertyName = propertyName;
                this.negate = false;
            }
        }

        static RestrictionPattern create(PropertyState stringProperty) {
            if (stringProperty.count() == 1) {
                return new HasPropertyPattern((String)stringProperty.getValue(Type.STRING));
            }
            return RestrictionPattern.EMPTY;
        }

        public boolean matches(@Nonnull Tree tree, @Nullable PropertyState property) {
            boolean match = false;
            if (tree.hasChild("jcr:content")) {
                match = tree.getChild("jcr:content").hasProperty(this.propertyName);
            }
            if (!match) {
                match = tree.hasProperty(this.propertyName);
            }
            return this.negate ? !match : match;
        }

        public boolean matches(@Nonnull String path) {
            return this.matches();
        }

        public boolean matches() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HasPropertyPattern{");
            sb.append("propertyName='").append(this.propertyName).append('\'');
            sb.append(", negate=").append(this.negate);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class PropertyRestrictionProvider
    extends AbstractRestrictionProvider {
        public static final String RESTRICTION_NAME = "hasProperty";

        public PropertyRestrictionProvider() {
            super(PropertyRestrictionProvider.supportedRestrictions());
        }

        private static Map<String, RestrictionDefinition> supportedRestrictions() {
            RestrictionDefinitionImpl dates = new RestrictionDefinitionImpl(RESTRICTION_NAME, Type.STRING, false);
            return Collections.singletonMap(dates.getName(), dates);
        }

        public RestrictionPattern getPattern(String oakPath, Tree tree) {
            PropertyState property;
            if (oakPath != null && (property = tree.getProperty(RESTRICTION_NAME)) != null) {
                return HasPropertyPattern.create(property);
            }
            return RestrictionPattern.EMPTY;
        }

        @Nonnull
        public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Set<Restriction> restrictions) {
            if (oakPath != null) {
                for (Restriction r : restrictions) {
                    String name = r.getDefinition().getName();
                    if (!RESTRICTION_NAME.equals(name)) continue;
                    return HasPropertyPattern.create(r.getProperty());
                }
            }
            return RestrictionPattern.EMPTY;
        }
    }
}

