/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.HashMap;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.junit.Assert;
import org.junit.Test;

public class GlobPatternTest {
    private static void assertMatch(GlobPattern gp, String testPath, Boolean expectedResult) {
        Boolean match = gp.matches(testPath);
        Assert.assertEquals((String)("Pattern : " + gp + "; TestPath : " + testPath), (Object)expectedResult, (Object)match);
    }

    @Test
    public void testMatchesWildcardAll() {
        HashMap<String, Boolean> tests = new HashMap<String, Boolean>();
        GlobPattern gp = GlobPattern.create("/a/b/c", "*");
        tests.put("/a/b/c", true);
        tests.put("/a/b/c/d", true);
        tests.put("/a/b/c/d/e", true);
        tests.put("/a/b/c/d/e/f", true);
        tests.put("/a/b/cde", true);
        tests.put("/a/b/cde/e/f", true);
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/b/c", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "*e");
        tests = new HashMap();
        tests.put("/a/b/c/e", true);
        tests.put("/a/b/c/d/e", true);
        tests.put("/a/b/c/gge", true);
        tests.put("/a/b/c/d/gge", true);
        tests.put("/a/b/ce", true);
        tests.put("/a/b/chee", true);
        tests.put("/a/b/cd/e", true);
        tests.put("/a/b/cd/f/e", true);
        tests.put("/a/b/cd/e", true);
        tests.put("/a/b/cd/f/e", true);
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/b/c", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c/d/f/e/f", false);
        tests.put("/a/b/c/d/f/efg", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/e/f", false);
        tests.put("/a/b/ce/", false);
        tests.put("/a/b/ceg", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "*/e");
        tests = new HashMap();
        tests.put("/a/b/c/e", true);
        tests.put("/a/b/c/d/e", true);
        tests.put("/a/b/cd/e", true);
        tests.put("/a/b/cd/f/e", true);
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/b/c", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c/d/f/e/f", false);
        tests.put("/a/b/c/d/f/efg", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/e/f", false);
        tests.put("/a/b/ce/", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c/e", "*");
        tests = new HashMap();
        tests.put("/a/b/c/e/f/g/h", true);
        tests.put("/a/b/c/e/d/e/f", true);
        tests.put("/a/b/c/e/d/e/f", true);
        tests.put("/a/b/c/e", true);
        tests.put("/a/b/c/e/", true);
        tests.put("/a/b/c/ef", true);
        tests.put("/a/b/c/ef/g", true);
        tests.put("/a/b/ce/f/g/h", false);
        tests.put("/a/b/ce/d/e/f", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/d/f/e/f", false);
        tests.put("/a/b/cee/d/e/f", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c/e", "/*");
        tests = new HashMap();
        tests.put("/a/b/c/e/f/g/h", true);
        tests.put("/a/b/c/e/d/e/f", true);
        tests.put("/a/b/c/e", false);
        tests.put("/a/b/c/e/", false);
        tests.put("/a/b/c/ef", false);
        tests.put("/a/b/ce/f/g/h", false);
        tests.put("/a/b/ce/d/e/f", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/d/f/e/f", false);
        tests.put("/a/b/cee/d/e/f", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "e/*");
        tests = new HashMap();
        tests.put("/a/b/ce/f/g/h", true);
        tests.put("/a/b/ce/d/e/f", true);
        tests.put("/a/b/c", false);
        tests.put("/a/b/ce", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/d/f/e/f", false);
        tests.put("/a/b/cee/d/e/f", false);
        tests.put("/a/b/ce/", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/", "*");
        tests = new HashMap();
        tests.put("/a", true);
        tests.put("/b/", true);
        tests.put("/c/d", true);
        tests.put("/a/b/ce/", true);
        tests.put("/a/b/ce/f/g/h", true);
        tests.put("/a/b/ce/d/e/f", true);
        tests.put("/", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "*e/*");
        tests = new HashMap();
        tests.put("/a/b/ceeeeeee/f/g/h", true);
        tests.put("/a/b/cde/d/e/f", true);
        tests.put("/a/b/c/d/e/f", true);
        tests.put("/a/b/ced/d/e/f", true);
        tests.put("/a/b/cde", false);
        tests.put("/a/b/ce/", false);
        tests.put("/a/b/c/d/e/", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/ed/f/f", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "/*e/*");
        tests = new HashMap();
        tests.put("/a/b/c/d/e/f", true);
        tests.put("/a/b/c/de/f", true);
        tests.put("/a/b/cde", false);
        tests.put("/a/b/ced/d/e/f", false);
        tests.put("/a/b/cde/d/e/f", false);
        tests.put("/a/b/ce/", false);
        tests.put("/a/b/c/d/e/", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/f/f", false);
        tests.put("/a/b/c/ed/f/f", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "/*cat");
        tests = new HashMap();
        tests.put("/a/b/c/cat", true);
        tests.put("/a/b/c/acat", true);
        tests.put("/a/b/c/f/cat", true);
        tests.put("/a/b/c/f/acat", true);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/cat/e", false);
        tests.put("/a/b/c/d/acat/e", false);
        tests.put("/a/b/c/d/cata/e", false);
        tests.put("/a/b/c/d/cate", false);
        tests.put("/a/b/cat", false);
        tests.put("/a/b/cat/ed/f/f", false);
        tests.put("/a/b/ced/cat", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "/*/cat");
        tests = new HashMap();
        tests.put("/a/b/c/a/cat", true);
        tests.put("/a/b/c/d/e/f/cat", true);
        tests.put("/a/b/c/cat", false);
        tests.put("/a/b/c/cate", false);
        tests.put("/a/b/c/acat", false);
        tests.put("/a/b/c/cat/d", false);
        tests.put("/a/b/c/d/acat", false);
        tests.put("/a/b/c/d/cate", false);
        tests.put("/a/b/c/d/cat/e", false);
        tests.put("/a/b/c/d/acat/e", false);
        tests.put("/a/b/c/d/cata/e", false);
        tests.put("/a/b/cat", false);
        tests.put("/a/b/cat/ed/f/f", false);
        tests.put("/a/b/ced/cat", false);
        tests.put("/a/b/ced/f/cat", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
        gp = GlobPattern.create("/a/b/c", "/cat*");
        tests = new HashMap();
        tests.put("/a/b/c/cat", true);
        tests.put("/a/b/c/cats", true);
        tests.put("/a/b/c/cat/s", true);
        tests.put("/a/b/c/cats/d/e/f", true);
        tests.put("/a/b/c/d/cat", false);
        tests.put("/a/b/c/d/cats", false);
        tests.put("/a/b/c/d/e/cat", false);
        tests.put("/a/b/c/d/e/cats", false);
        tests.put("/a/b/c/acat", false);
        tests.put("/a/b/c/d/acat", false);
        tests.put("/a/b/c/d/cat/e", false);
        tests.put("/a/b/c/d/acat/e", false);
        tests.put("/a/b/c/d/cata/e", false);
        tests.put("/a/b/cat", false);
        tests.put("/a/b/cat/ed/f/f", false);
        tests.put("/a/b/ced/cat", false);
        tests.put("/a/b/ced/f/cat", false);
        for (String testPath : tests.keySet()) {
            GlobPatternTest.assertMatch(gp, testPath, (Boolean)tests.get(testPath));
        }
    }

    @Test
    public void testEmptyRestriction() {
        GlobPattern gp = GlobPattern.create("/", "");
        HashMap<String, Boolean> tests = new HashMap<String, Boolean>();
        tests.put("/", true);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/c", false);
        tests.put("/a", false);
        tests.put("/a/b/cde", false);
        for (String toTest : tests.keySet()) {
            Assert.assertTrue((String)(gp + " : " + toTest), (((Boolean)tests.get(toTest)).booleanValue() == gp.matches(toTest) ? 1 : 0) != 0);
        }
        gp = GlobPattern.create("/a/b/c", "");
        tests = new HashMap();
        tests.put("/a/b/c", true);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/a/b/cde", false);
        for (String toTest : tests.keySet()) {
            Assert.assertTrue((String)(gp + " : " + toTest), (((Boolean)tests.get(toTest)).booleanValue() == gp.matches(toTest) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPathRestriction() {
        GlobPattern gp = GlobPattern.create("/a/b/c", "d");
        HashMap<String, Boolean> tests = new HashMap<String, Boolean>();
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", false);
        tests.put("/a/b/c/d/e/f", false);
        tests.put("/a/b/cd", true);
        tests.put("/a/b/cd/e", true);
        tests.put("/a/b/cd/e/f", true);
        tests.put("/a/b/cde", false);
        for (String toTest : tests.keySet()) {
            Assert.assertTrue((String)(gp + " : " + toTest), (((Boolean)tests.get(toTest)).booleanValue() == gp.matches(toTest) ? 1 : 0) != 0);
        }
        gp = GlobPattern.create("/a/b/c", "/d");
        tests = new HashMap();
        tests.put("/", false);
        tests.put("/a", false);
        tests.put("/a/b/c", false);
        tests.put("/a/b/c/d", true);
        tests.put("/a/b/c/d/e/f", true);
        tests.put("/a/b/cd", false);
        tests.put("/a/b/cd/e", false);
        tests.put("/a/b/cd/e/f", false);
        tests.put("/a/b/cde", false);
        for (String toTest : tests.keySet()) {
            Assert.assertTrue((String)(gp + " : " + toTest), (((Boolean)tests.get(toTest)).booleanValue() == gp.matches(toTest) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMaxOccurrences() {
        GlobPattern gp = GlobPattern.create("/", "1*/2*/3*/4*/5*/6*/7*/8*/9*/10*/11*/12*/13*/14*/15*/16*/17*/18*/19*/20*/21*");
        try {
            gp.matches("/1/2/3/4/5/6/7/8/9/10/11/12/13/14/15/16/17/18/19/20/21");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            gp.matches("/11/22/33/44/55/66/77/88/99/100/111/122/133/144/155/166/177/188/199/200/211");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

