/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.security.authorization.restriction.ItemNamePattern;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.junit.Assert;
import org.junit.Test;

public class ItemNamePatternTest
extends AbstractSecurityTest {
    private ItemNamePattern pattern = new ItemNamePattern((Iterable<String>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"));

    @Test
    public void testMatchesItem() throws Exception {
        NodeUtil rootTree = new NodeUtil(this.root.getTree("/"));
        ImmutableList matching = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d/e/a", (Object)"a/b/c/d/b", (Object)"test/c");
        for (String relPath : matching) {
            Tree testTree = rootTree.getOrAddTree(relPath, "oak:Unstructured").getTree();
            Assert.assertTrue((boolean)this.pattern.matches(testTree, null));
            Assert.assertTrue((boolean)this.pattern.matches(testTree, PropertyStates.createProperty((String)"a", (Object)Boolean.FALSE)));
            Assert.assertFalse((boolean)this.pattern.matches(testTree, PropertyStates.createProperty((String)"f", (Object)"anyval")));
        }
        ImmutableList notMatching = ImmutableList.of((Object)"d", (Object)"b/d", (Object)"d/e/f", (Object)"c/b/abc");
        for (String relPath : notMatching) {
            Tree testTree = rootTree.getOrAddTree(relPath, "oak:Unstructured").getTree();
            Assert.assertFalse((boolean)this.pattern.matches(testTree, null));
            Assert.assertTrue((boolean)this.pattern.matches(testTree, PropertyStates.createProperty((String)"a", (Object)Boolean.FALSE)));
            Assert.assertFalse((boolean)this.pattern.matches(testTree, PropertyStates.createProperty((String)"f", (Object)"anyval")));
        }
    }

    @Test
    public void testMatchesPath() {
        ImmutableList matching = ImmutableList.of((Object)"/a", (Object)"/b", (Object)"/c", (Object)"/d/e/a", (Object)"/a/b/c/d/b", (Object)"/test/c");
        for (String p : matching) {
            Assert.assertTrue((boolean)this.pattern.matches(p));
        }
        ImmutableList notMatching = ImmutableList.of((Object)"/", (Object)"/d", (Object)"/b/d", (Object)"/d/e/f", (Object)"/c/b/abc");
        for (String p : notMatching) {
            Assert.assertFalse((boolean)this.pattern.matches(p));
        }
    }

    @Test
    public void testMatchesNull() {
        Assert.assertFalse((boolean)this.pattern.matches());
    }
}

