/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.junit.Assert;
import org.junit.Test;

public class ItemNameRestrictionTest
extends AbstractSecurityTest {
    private ValueFactory vf;
    private ContentSession testSession;
    private Principal testPrincipal;
    private Group testGroup;

    public void before() throws Exception {
        super.before();
        Tree rootTree = this.root.getTree("/");
        NodeUtil f = new NodeUtil(rootTree).getOrAddTree("a/d/b/e/c/f", "oak:Unstructured");
        NodeUtil c = f.getParent();
        c.setString("prop", "value");
        c.setString("a", "value");
        this.testPrincipal = this.getTestUser().getPrincipal();
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)"/a");
        this.vf = new ValueFactoryImpl(this.root, NamePathMapper.DEFAULT);
        acl.addEntry(this.testPrincipal, this.privilegesFromNames(new String[]{"jcr:read", "rep:addProperties", "jcr:addChildNodes", "jcr:removeNode"}), true, Collections.emptyMap(), (Map)ImmutableMap.of((Object)"rep:itemNames", (Object)new Value[]{this.vf.createValue("a", 7), this.vf.createValue("b", 7), this.vf.createValue("c", 7)}));
        acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        UserManager uMgr = this.getUserManager(this.root);
        this.testGroup = uMgr.createGroup("testGroup" + UUID.randomUUID());
        this.root.commit();
        this.testSession = this.createTestSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after() throws Exception {
        try {
            this.testSession.close();
            this.root.refresh();
            Tree a = this.root.getTree("/a");
            if (a.exists()) {
                a.remove();
                this.root.commit();
            }
        }
        finally {
            super.after();
        }
    }

    @Test
    public void testRead() {
        Root testRoot = this.testSession.getLatestRoot();
        ImmutableList visible = ImmutableList.of((Object)"/a", (Object)"/a/d/b", (Object)"/a/d/b/e/c");
        for (String p : visible) {
            Assert.assertTrue((boolean)testRoot.getTree(p).exists());
        }
        ImmutableList invisible = ImmutableList.of((Object)"/", (Object)"/a/d", (Object)"/a/d/b/e", (Object)"/a/d/b/e/c/f");
        for (String p : invisible) {
            Assert.assertFalse((boolean)testRoot.getTree(p).exists());
        }
        Tree c = testRoot.getTree("/a/d/b/e/c");
        Assert.assertNull((Object)c.getProperty("jcr:primaryType"));
        Assert.assertNull((Object)c.getProperty("prop"));
        Assert.assertNotNull((Object)c.getProperty("a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddProperty() throws Exception {
        Tree t;
        Root testRoot = this.testSession.getLatestRoot();
        ImmutableList paths = ImmutableList.of((Object)"/a", (Object)"/a/d/b", (Object)"/a/d/b/e/c");
        for (String p : paths) {
            t = testRoot.getTree(p);
            t.setProperty("b", (Object)"anyvalue");
            testRoot.commit();
        }
        for (String p : paths) {
            t = testRoot.getTree(p);
            try {
                t.setProperty("notAllowed", (Object)"anyvalue");
                testRoot.commit();
                Assert.fail();
            }
            catch (CommitFailedException e) {
                Assert.assertTrue((boolean)e.isAccessViolation());
            }
            finally {
                testRoot.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyProperty() throws Exception {
        Root testRoot = this.testSession.getLatestRoot();
        Tree c = testRoot.getTree("/a/d/b/e/c");
        try {
            c.setProperty("a", (Object)"anyvalue");
            testRoot.commit();
            Assert.fail();
        }
        catch (CommitFailedException e) {
            Assert.assertTrue((boolean)e.isAccessViolation());
        }
        finally {
            testRoot.refresh();
        }
    }

    @Test
    public void testAddChild() throws Exception {
        Root testRoot = this.testSession.getLatestRoot();
        ImmutableList paths = ImmutableList.of((Object)"/a", (Object)"/a/d/b", (Object)"/a/d/b/e/c");
        for (String p : paths) {
            NodeUtil t = new NodeUtil(testRoot.getTree(p));
            t.addChild("c", "oak:Unstructured");
            testRoot.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveTree() throws Exception {
        Root testRoot = this.testSession.getLatestRoot();
        ImmutableList paths = ImmutableList.of((Object)"/a/d/b/e/c", (Object)"/a/d/b", (Object)"/a");
        for (String p : paths) {
            try {
                testRoot.getTree(p).remove();
                testRoot.commit();
                Assert.fail();
            }
            catch (CommitFailedException e) {
                Assert.assertTrue((boolean)e.isAccessViolation());
            }
            finally {
                testRoot.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveTree2() throws Exception {
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)"/a");
        acl.addEntry(this.testPrincipal, this.privilegesFromNames(new String[]{"jcr:read", "jcr:removeChildNodes"}), true);
        acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        this.root.commit();
        Root testRoot = this.testSession.getLatestRoot();
        ImmutableList paths = ImmutableList.of((Object)"/a/d/b/e/c", (Object)"/a/d/b");
        for (String p : paths) {
            testRoot.getTree(p).remove();
            testRoot.commit();
        }
        try {
            testRoot.getTree("/a").remove();
            testRoot.commit();
            Assert.fail();
        }
        catch (CommitFailedException e) {
            Assert.assertTrue((boolean)e.isAccessViolation());
        }
        finally {
            testRoot.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyMembersOnly() throws Exception {
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        String path = PathUtils.getAncestorPath((String)"/rep:security/rep:authorizables/rep:users", (int)1);
        try {
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
            acl.addEntry(this.testPrincipal, this.privilegesFromNames(new String[]{"jcr:read"}), true);
            acl.addEntry(this.testPrincipal, this.privilegesFromNames(new String[]{"rep:userManagement"}), true, Collections.emptyMap(), (Map)ImmutableMap.of((Object)"rep:itemNames", (Object)new Value[]{this.vf.createValue("rep:members", 7)}));
            acMgr.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
            this.root.commit();
            Root testRoot = this.testSession.getLatestRoot();
            UserManager uMgr = this.getUserManager(testRoot);
            Group gr = (Group)uMgr.getAuthorizable(this.testGroup.getID(), Group.class);
            User u = (User)uMgr.getAuthorizable(this.getTestUser().getID(), User.class);
            gr.addMember((Authorizable)u);
            testRoot.commit();
            try {
                u.changePassword("blub");
                testRoot.commit();
                Assert.fail();
            }
            catch (CommitFailedException e) {
                Assert.assertTrue((boolean)e.isAccessViolation());
            }
            finally {
                testRoot.refresh();
            }
        }
        catch (CommitFailedException e) {
            Assert.assertTrue((boolean)e.isAccessViolation());
        }
        finally {
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
            if (acl != null) {
                acMgr.removePolicy(acl.getPath(), (AccessControlPolicy)acl);
                this.root.commit();
            }
        }
    }
}

