/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTypePattern
implements RestrictionPattern {
    private static final Logger log = LoggerFactory.getLogger(NodeTypePattern.class);
    private final Set<String> nodeTypeNames;

    NodeTypePattern(@Nonnull Iterable<String> nodeTypeNames) {
        this.nodeTypeNames = ImmutableSet.copyOf(nodeTypeNames);
    }

    public boolean matches(@Nonnull Tree tree, @Nullable PropertyState property) {
        return this.nodeTypeNames.contains(TreeUtil.getPrimaryTypeName((Tree)tree));
    }

    public boolean matches(@Nonnull String path) {
        log.debug("Unable to validate node type restriction.");
        return false;
    }

    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return this.nodeTypeNames.hashCode();
    }

    public String toString() {
        return this.nodeTypeNames.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeTypePattern) {
            NodeTypePattern other = (NodeTypePattern)obj;
            return this.nodeTypeNames.equals(other.nodeTypeNames);
        }
        return false;
    }
}

