/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.security.Principal;
import java.util.HashMap;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.AbstractSecurityTest;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.apache.jackrabbit.value.StringValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PermissionTest
extends AbstractSecurityTest {
    private static final String TEST_ROOT_PATH = "/testRoot";
    private static final String TEST_A_PATH = "/testRoot/a";
    private static final String TEST_B_PATH = "/testRoot/a/b";
    private static final String TEST_C_PATH = "/testRoot/a/b/c";
    private static final String TEST_D_PATH = "/testRoot/a/b/c/d";
    private static final String TEST_E_PATH = "/testRoot/a/b/c/d/e";
    private Principal testPrincipal;

    @Before
    public void before() throws Exception {
        super.before();
        NodeUtil rootNode = new NodeUtil(this.root.getTree("/"));
        NodeUtil testRootNode = rootNode.addChild("testRoot", "nt:unstructured");
        NodeUtil a = testRootNode.addChild("a", "nt:unstructured");
        NodeUtil b = a.addChild("b", "nt:unstructured");
        NodeUtil c = b.addChild("c", "nt:unstructured");
        NodeUtil d = c.addChild("d", "nt:unstructured");
        d.addChild("e", "nt:unstructured");
        this.root.commit();
        this.testPrincipal = this.getTestUser().getPrincipal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() throws Exception {
        try {
            this.root.refresh();
            this.root.getTree(TEST_ROOT_PATH).remove();
            this.root.commit();
        }
        finally {
            super.after();
        }
    }

    private void addEntry(String path, boolean grant, String restriction, String ... privilegeNames) throws Exception {
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
        if (restriction.length() > 0) {
            HashMap<String, StringValue> rs = new HashMap<String, StringValue>();
            rs.put("rep:glob", new StringValue(restriction));
            acl.addEntry(this.testPrincipal, AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privilegeNames), grant, rs);
        } else {
            acl.addEntry(this.testPrincipal, AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])privilegeNames), grant);
        }
        acMgr.setPolicy(path, (AccessControlPolicy)acl);
        this.root.commit();
    }

    private void assertIsGranted(PermissionProvider pp, Root root, boolean allow, String path, long permissions) {
        Assert.assertEquals((String)("user should " + (allow ? "" : "not ") + "have " + permissions + " on " + path), (Object)allow, (Object)pp.isGranted(root.getTree(path), null, permissions));
    }

    private PermissionProvider getPermissionProvider(ContentSession session) {
        return ((AuthorizationConfiguration)this.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class)).getPermissionProvider(this.root, session.getWorkspaceName(), session.getAuthInfo().getPrincipals());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasPermission() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_B_PATH, true, "", "jcr:removeNode");
        this.addEntry(TEST_C_PATH, false, "", "jcr:removeNode");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 64L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 64L);
            try {
                testRoot.getTree(TEST_C_PATH).remove();
                testRoot.commit();
                Assert.fail((String)"removing node on /a/b/c should fail");
            }
            catch (CommitFailedException e) {
                // empty catch block
            }
        }
        finally {
            testSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasPermissionWithRestrictions() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_A_PATH, false, "*/c", "jcr:removeNode");
        this.addEntry(TEST_A_PATH, true, "*/b", "jcr:removeNode");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 64L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_E_PATH, 64L);
            testRoot.getTree(TEST_D_PATH).remove();
            testRoot.commit();
            try {
                testRoot.getTree(TEST_C_PATH).remove();
                testRoot.commit();
                Assert.fail((String)"user should not be able to remove c");
            }
            catch (CommitFailedException e) {
                // empty catch block
            }
        }
        finally {
            testSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasPermissionWithRestrictions2() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_A_PATH, true, "*/b", "jcr:removeNode");
        this.addEntry(TEST_A_PATH, false, "*/c", "jcr:removeNode");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 64L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 64L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 64L);
            testRoot.getTree(TEST_D_PATH).remove();
            testRoot.commit();
            try {
                testRoot.getTree(TEST_C_PATH).remove();
                testRoot.commit();
                Assert.fail((String)"should not be able to delete /testRoot/a/b/c");
            }
            catch (CommitFailedException e) {
                testRoot.refresh();
            }
        }
        finally {
            testSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtectPropertiesByRestriction() throws Exception {
        this.addEntry(TEST_ROOT_PATH, true, "", "jcr:read", "rep:write");
        this.addEntry(TEST_A_PATH, false, "*/c", "jcr:modifyProperties");
        ContentSession testSession = this.createTestSession();
        try {
            Root testRoot = testSession.getLatestRoot();
            PermissionProvider pp = this.getPermissionProvider(testSession);
            this.assertIsGranted(pp, testRoot, true, TEST_A_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_B_PATH, 8L);
            this.assertIsGranted(pp, testRoot, false, TEST_C_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_D_PATH, 8L);
            this.assertIsGranted(pp, testRoot, true, TEST_E_PATH, 8L);
        }
        finally {
            testSession.close();
        }
    }
}

