/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.ItemNamePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.NodeTypePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrefixPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractAccessControlTest;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestrictionProviderImplTest
extends AbstractAccessControlTest
implements AccessControlConstants {
    private RestrictionProviderImpl provider;

    @Before
    public void before() throws Exception {
        super.before();
        this.provider = new RestrictionProviderImpl();
    }

    @Test
    public void testGetSupportedDefinitions() {
        Assert.assertTrue((boolean)this.provider.getSupportedRestrictions(null).isEmpty());
        Set defs = this.provider.getSupportedRestrictions("/testPath");
        Assert.assertNotNull((Object)defs);
        Assert.assertEquals((long)4L, (long)defs.size());
        for (RestrictionDefinition def : defs) {
            if ("rep:glob".equals(def.getName())) {
                Assert.assertEquals((Object)Type.STRING, (Object)def.getRequiredType());
                Assert.assertFalse((boolean)def.isMandatory());
                continue;
            }
            if ("rep:ntNames".equals(def.getName())) {
                Assert.assertEquals((Object)Type.NAMES, (Object)def.getRequiredType());
                Assert.assertFalse((boolean)def.isMandatory());
                continue;
            }
            if ("rep:prefixes".equals(def.getName())) {
                Assert.assertEquals((Object)Type.STRINGS, (Object)def.getRequiredType());
                Assert.assertFalse((boolean)def.isMandatory());
                continue;
            }
            if ("rep:itemNames".equals(def.getName())) {
                Assert.assertEquals((Object)Type.NAMES, (Object)def.getRequiredType());
                Assert.assertFalse((boolean)def.isMandatory());
                continue;
            }
            Assert.fail((String)("unexpected restriction " + def.getName()));
        }
    }

    @Test
    public void testGetRestrictionPattern() throws Exception {
        HashMap map = Maps.newHashMap();
        map.put(PropertyStates.createProperty((String)"rep:glob", (Object)"/*/jcr:content"), GlobPattern.create("/testPath", "/*/jcr:content"));
        ImmutableList ntNames = ImmutableList.of((Object)"nt:folder", (Object)"nt:linkedFile");
        map.put(PropertyStates.createProperty((String)"rep:ntNames", (Object)ntNames, (Type)Type.NAMES), new NodeTypePattern((Iterable<String>)ntNames));
        NodeUtil tree = new NodeUtil(this.root.getTree("/")).getOrAddTree("testPath", "nt:unstructured");
        Tree restrictions = tree.addChild("rep:restrictions", "rep:Restrictions").getTree();
        for (Map.Entry entry : map.entrySet()) {
            restrictions.setProperty((PropertyState)entry.getKey());
            RestrictionPattern pattern = this.provider.getPattern("/testPath", restrictions);
            Assert.assertEquals(entry.getValue(), (Object)pattern);
            restrictions.removeProperty(((PropertyState)entry.getKey()).getName());
        }
        for (Map.Entry entry : map.entrySet()) {
            restrictions.setProperty((PropertyState)entry.getKey());
        }
        RestrictionPattern pattern = this.provider.getPattern("/testPath", restrictions);
        Assert.assertTrue((boolean)(pattern instanceof CompositePattern));
    }

    @Test
    public void testGetPatternForAllSupported() throws Exception {
        HashMap map = Maps.newHashMap();
        map.put(PropertyStates.createProperty((String)"rep:glob", (Object)"/*/jcr:content"), GlobPattern.create("/testPath", "/*/jcr:content"));
        ImmutableList ntNames = ImmutableList.of((Object)"nt:folder", (Object)"nt:linkedFile");
        map.put(PropertyStates.createProperty((String)"rep:ntNames", (Object)ntNames, (Type)Type.NAMES), new NodeTypePattern((Iterable<String>)ntNames));
        ImmutableList prefixes = ImmutableList.of((Object)"rep", (Object)"jcr");
        map.put(PropertyStates.createProperty((String)"rep:prefixes", (Object)prefixes, (Type)Type.STRINGS), new PrefixPattern((Iterable<String>)prefixes));
        ImmutableList itemNames = ImmutableList.of((Object)"abc", (Object)"jcr:primaryType");
        map.put(PropertyStates.createProperty((String)"rep:itemNames", (Object)prefixes, (Type)Type.NAMES), new ItemNamePattern((Iterable<String>)itemNames));
        NodeUtil tree = new NodeUtil(this.root.getTree("/")).getOrAddTree("testPath", "nt:unstructured");
        Tree restrictions = tree.addChild("rep:restrictions", "rep:Restrictions").getTree();
        for (Map.Entry entry : map.entrySet()) {
            restrictions.setProperty((PropertyState)entry.getKey());
        }
        RestrictionPattern pattern = this.provider.getPattern("/testPath", restrictions);
        Assert.assertTrue((boolean)(pattern instanceof CompositePattern));
    }

    @Test
    public void testGetPatternFromRestrictions() throws Exception {
        HashMap map = Maps.newHashMap();
        map.put(PropertyStates.createProperty((String)"rep:glob", (Object)"/*/jcr:content"), GlobPattern.create("/testPath", "/*/jcr:content"));
        ImmutableList ntNames = ImmutableList.of((Object)"nt:folder", (Object)"nt:linkedFile");
        map.put(PropertyStates.createProperty((String)"rep:ntNames", (Object)ntNames, (Type)Type.NAMES), new NodeTypePattern((Iterable<String>)ntNames));
        ImmutableList prefixes = ImmutableList.of((Object)"rep", (Object)"jcr");
        map.put(PropertyStates.createProperty((String)"rep:prefixes", (Object)prefixes, (Type)Type.STRINGS), new PrefixPattern((Iterable<String>)prefixes));
        ImmutableList itemNames = ImmutableList.of((Object)"abc", (Object)"jcr:primaryType");
        map.put(PropertyStates.createProperty((String)"rep:itemNames", (Object)itemNames, (Type)Type.NAMES), new ItemNamePattern((Iterable<String>)itemNames));
        NodeUtil tree = new NodeUtil(this.root.getTree("/")).getOrAddTree("testPath", "nt:unstructured");
        Tree restrictions = tree.addChild("rep:restrictions", "rep:Restrictions").getTree();
        for (Map.Entry entry : map.entrySet()) {
            restrictions.setProperty((PropertyState)entry.getKey());
            RestrictionPattern pattern = this.provider.getPattern("/testPath", this.provider.readRestrictions("/testPath", tree.getTree()));
            Assert.assertEquals(entry.getValue(), (Object)pattern);
            restrictions.removeProperty(((PropertyState)entry.getKey()).getName());
        }
        for (Map.Entry entry : map.entrySet()) {
            restrictions.setProperty((PropertyState)entry.getKey());
        }
        RestrictionPattern pattern = this.provider.getPattern("/testPath", this.provider.readRestrictions("/testPath", tree.getTree()));
        Assert.assertTrue((boolean)(pattern instanceof CompositePattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateGlobRestriction() throws Exception {
        Tree t = new NodeUtil(this.root.getTree("/")).addChild("testTree", "nt:unstructured").getTree();
        String path = t.getPath();
        JackrabbitAccessControlManager acMgr = this.getAccessControlManager(this.root);
        ImmutableList globs = ImmutableList.of((Object)"/1*/2*/3*/4*/5*/6*/7*/8*/9*/10*/11*/12*/13*/14*/15*/16*/17*/18*/19*/20*/21*", (Object)"*********************");
        for (String glob : globs) {
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acMgr, (String)path);
            acl.addEntry(this.getTestPrincipal(), AccessControlUtils.privilegesFromNames((AccessControlManager)acMgr, (String[])new String[]{"jcr:read"}), true, Collections.singletonMap("rep:glob", this.getValueFactory().createValue(glob)));
            acMgr.setPolicy(path, (AccessControlPolicy)acl);
            try {
                this.provider.validateRestrictions(path, t.getChild("rep:policy").getChild("allow"));
                Assert.fail((String)"AccessControlException expected.");
            }
            catch (AccessControlException e) {}
            continue;
            finally {
                acMgr.removePolicy(path, (AccessControlPolicy)acl);
            }
        }
    }
}

