/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.principal.PrincipalProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;

@Component
@Service(value={PrincipalConfiguration.class, SecurityConfiguration.class})
public class PrincipalConfigurationImpl
extends ConfigurationBase
implements PrincipalConfiguration {
    public PrincipalConfigurationImpl() {
    }

    public PrincipalConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.principal"));
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Nonnull
    public PrincipalManager getPrincipalManager(Root root, NamePathMapper namePathMapper) {
        PrincipalProvider principalProvider = this.getPrincipalProvider(root, namePathMapper);
        return new PrincipalManagerImpl(principalProvider);
    }

    @Nonnull
    public PrincipalProvider getPrincipalProvider(Root root, NamePathMapper namePathMapper) {
        UserConfiguration uc = (UserConfiguration)this.getSecurityProvider().getConfiguration(UserConfiguration.class);
        PrincipalProvider principalProvider = uc.getUserPrincipalProvider(root, namePathMapper);
        if (principalProvider != null) {
            return principalProvider;
        }
        return new PrincipalProviderImpl(root, uc, namePathMapper);
    }

    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.principal";
    }
}

