/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.security.principal.PrincipalProviderImpl;
import org.apache.jackrabbit.oak.spi.security.principal.AbstractPrincipalProviderTest;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.junit.Assert;
import org.junit.Test;

public class PrincipalProviderImplTest
extends AbstractPrincipalProviderTest {
    protected PrincipalProvider createPrincipalProvider() {
        return new PrincipalProviderImpl(this.root, this.getUserConfiguration(), this.namePathMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEveryoneMembers() throws Exception {
        Principal everyone = this.principalProvider.getPrincipal("everyone");
        Assert.assertTrue((boolean)(everyone instanceof EveryonePrincipal));
        Group everyoneGroup = null;
        try {
            UserManager userMgr = this.getUserManager(this.root);
            everyoneGroup = userMgr.createGroup("everyone");
            this.root.commit();
            Principal ep = this.principalProvider.getPrincipal("everyone");
            ImmutableSet everyoneMembers = ImmutableSet.copyOf(Collections.list(((java.security.acl.Group)ep).members()));
            Iterator all = this.principalProvider.findPrincipals(3);
            while (all.hasNext()) {
                Principal p = (Principal)all.next();
                if (everyone.equals(p)) {
                    Assert.assertFalse((boolean)everyoneMembers.contains(p));
                    continue;
                }
                Assert.assertTrue((boolean)everyoneMembers.contains(p));
            }
        }
        finally {
            if (everyoneGroup != null) {
                everyoneGroup.remove();
                this.root.commit();
            }
        }
    }
}

