/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;

public abstract class AbstractCacheStats
extends AnnotatedStandardMBean
implements CacheStatsMBean {
    @Nonnull
    private final String name;
    private CacheStats lastSnapshot = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);

    protected AbstractCacheStats(@Nonnull String name) {
        super(CacheStatsMBean.class);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    protected abstract CacheStats getCurrentStats();

    private CacheStats stats() {
        return this.getCurrentStats().minus(this.lastSnapshot);
    }

    public synchronized void resetStats() {
        this.lastSnapshot = this.getCurrentStats();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public long getRequestCount() {
        return this.stats().requestCount();
    }

    public long getHitCount() {
        return this.stats().hitCount();
    }

    public double getHitRate() {
        return this.stats().hitRate();
    }

    public long getMissCount() {
        return this.stats().missCount();
    }

    public double getMissRate() {
        return this.stats().missRate();
    }

    public long getLoadCount() {
        return this.stats().loadCount();
    }

    public long getLoadSuccessCount() {
        return this.stats().loadSuccessCount();
    }

    public long getLoadExceptionCount() {
        return this.stats().loadExceptionCount();
    }

    public double getLoadExceptionRate() {
        return this.stats().loadExceptionRate();
    }

    public long getTotalLoadTime() {
        return this.stats().totalLoadTime();
    }

    public double getAverageLoadPenalty() {
        return this.stats().averageLoadPenalty();
    }

    public long getEvictionCount() {
        return this.stats().evictionCount();
    }

    public String cacheInfoAsString() {
        return Objects.toStringHelper((String)"CacheStats").add("hitCount", this.getHitCount()).add("hitRate", (Object)String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", (Object)String.format("%1.2f", this.getMissRate())).add("requestCount", this.getRequestCount()).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("loadExceptionCount", this.getLoadExceptionCount()).add("totalLoadTime", (Object)AbstractCacheStats.timeInWords(this.getTotalLoadTime())).add("averageLoadPenalty", (Object)String.format("%1.2f ns", this.getAverageLoadPenalty())).add("evictionCount", this.getEvictionCount()).add("elementCount", this.getElementCount()).add("totalWeight", (Object)IOUtils.humanReadableByteCount((long)this.estimateCurrentWeight())).add("maxWeight", (Object)IOUtils.humanReadableByteCount((long)this.getMaxTotalWeight())).toString();
    }

    public static String timeInWords(long nanos) {
        long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

