/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneDocumentMaker;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateCloner;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.ReindexOperations;
import org.apache.jackrabbit.oak.plugins.index.lucene.binary.BinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetsConfigProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.facet.FacetsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorContext
implements FacetsConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditorContext.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LuceneIndexEditorContext.class.getName() + ".perf")));
    private FacetsConfig facetsConfig;
    private IndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private final LuceneIndexWriterFactory indexWriterFactory;
    private LuceneIndexWriter writer = null;
    private long indexedNodes;
    private final IndexUpdateCallback updateCallback;
    private boolean reindex;
    private final ExtractedTextCache extractedTextCache;
    private final IndexAugmentorFactory augmentorFactory;
    private final NodeState root;
    private final IndexingContext indexingContext;
    private final boolean asyncIndexing;
    private static Clock clock = Clock.SIMPLE;
    private final boolean indexDefnRewritten;
    private BinaryTextExtractor textExtractor;
    private PropertyUpdateCallback propertyUpdateCallback;

    LuceneIndexEditorContext(NodeState root, NodeBuilder definition, @Nullable IndexDefinition indexDefinition, IndexUpdateCallback updateCallback, LuceneIndexWriterFactory indexWriterFactory, ExtractedTextCache extractedTextCache, IndexAugmentorFactory augmentorFactory, IndexingContext indexingContext, boolean asyncIndexing) {
        this.root = root;
        this.indexingContext = (IndexingContext)Preconditions.checkNotNull((Object)indexingContext);
        this.definitionBuilder = definition;
        this.indexWriterFactory = indexWriterFactory;
        this.definition = indexDefinition != null ? indexDefinition : LuceneIndexEditorContext.createIndexDefinition(root, definition, indexingContext, asyncIndexing);
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
        this.extractedTextCache = extractedTextCache;
        this.augmentorFactory = augmentorFactory;
        this.asyncIndexing = asyncIndexing;
        if (this.definition.isOfOldFormat()) {
            this.indexDefnRewritten = true;
            IndexDefinition.updateDefinition(definition, indexingContext.getIndexPath());
        } else {
            this.indexDefnRewritten = false;
        }
    }

    LuceneIndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.indexWriterFactory.newInstance(this.definition, this.definitionBuilder, this.reindex);
        }
        return this.writer;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    @CheckForNull
    public PropertyUpdateCallback getPropertyUpdateCallback() {
        return this.propertyUpdateCallback;
    }

    void setPropertyUpdateCallback(PropertyUpdateCallback propertyUpdateCallback) {
        this.propertyUpdateCallback = propertyUpdateCallback;
    }

    void closeWriter() throws IOException {
        Calendar currentTime = LuceneIndexEditorContext.getCalendar();
        long start = PERF_LOGGER.start();
        boolean indexUpdated = this.getWriter().close(currentTime.getTimeInMillis());
        if (indexUpdated) {
            PERF_LOGGER.end(start, -1L, "Closed writer for directory {}", (Object)this.definition);
            NodeBuilder status = this.definitionBuilder.child(":status");
            status.setProperty("lastUpdated", (Object)this.getUpdatedTime(currentTime), Type.DATE);
            status.setProperty("indexedNodes", (Object)this.indexedNodes);
            PERF_LOGGER.end(start, -1L, "Overall Closed IndexWriter for directory {}", (Object)this.definition);
            if (this.textExtractor != null) {
                this.textExtractor.done(this.reindex);
            }
        }
    }

    private String getUpdatedTime(Calendar currentTime) {
        CommitInfo info = this.getIndexingContext().getCommitInfo();
        String checkpointTime = (String)info.getInfo().get("indexingCheckpointTime");
        if (checkpointTime != null) {
            return checkpointTime;
        }
        return ISO8601.format((Calendar)currentTime);
    }

    static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    private static Calendar getCalendar() {
        Calendar ret = Calendar.getInstance();
        ret.setTime(clock.getDate());
        return ret;
    }

    public void enableReindexMode() {
        this.reindex = true;
        ReindexOperations reindexOps = new ReindexOperations(this.root, this.definitionBuilder, this.definition.getIndexPath());
        this.definition = reindexOps.apply(this.indexDefnRewritten);
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    boolean isAsyncIndexing() {
        return this.asyncIndexing;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    LuceneDocumentMaker newDocumentMaker(IndexDefinition.IndexingRule rule, String path) {
        LuceneIndexEditorContext facetsConfigProvider = this.isAsyncIndexing() ? this : null;
        return new LuceneDocumentMaker(this.getTextExtractor(), facetsConfigProvider, this.augmentorFactory, this.definition, rule, path);
    }

    @Override
    public FacetsConfig getFacetsConfig() {
        if (this.facetsConfig == null) {
            this.facetsConfig = FacetHelper.getFacetsConfig(this.definitionBuilder);
        }
        return this.facetsConfig;
    }

    private BinaryTextExtractor getTextExtractor() {
        if (this.textExtractor == null && this.isAsyncIndexing()) {
            this.textExtractor = new BinaryTextExtractor(this.extractedTextCache, this.definition, this.reindex);
        }
        return this.textExtractor;
    }

    public boolean isReindex() {
        return this.reindex;
    }

    public static String configureUniqueId(NodeBuilder definition) {
        NodeBuilder status = definition.child(":status");
        String uid = status.getString("uid");
        if (uid == null) {
            try {
                uid = String.valueOf(Clock.SIMPLE.getTimeIncreasing());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                uid = String.valueOf(Clock.SIMPLE.getTime());
            }
            status.setProperty("uid", (Object)uid);
        }
        return uid;
    }

    private static IndexDefinition createIndexDefinition(NodeState root, NodeBuilder definition, IndexingContext indexingContext, boolean asyncIndexing) {
        NodeState defnState = definition.getBaseState();
        if (asyncIndexing && !IndexDefinition.isDisableStoredIndexDefinition()) {
            if (definition.getBoolean("refresh")) {
                definition.removeProperty("refresh");
                NodeState clonedState = NodeStateCloner.cloneVisibleState(defnState);
                definition.setChildNode(":index-definition", clonedState);
                log.info("Refreshed the index definition for [{}]", (Object)indexingContext.getIndexPath());
                if (log.isDebugEnabled()) {
                    log.debug("Updated index definition is {}", (Object)NodeStateUtils.toString((NodeState)clonedState));
                }
            } else if (!definition.hasChildNode(":index-definition")) {
                definition.setChildNode(":index-definition", NodeStateCloner.cloneVisibleState(defnState));
                log.info("Stored the cloned index definition for [{}]. Changes in index definition would now only be effective post reindexing", (Object)indexingContext.getIndexPath());
            }
        }
        return new IndexDefinition(root, defnState, indexingContext.getIndexPath());
    }
}

