/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateCloner;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexConsistencyChecker;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexersLucene;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexInfoProvider
implements IndexInfoProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final AsyncIndexInfoService asyncInfoService;
    private final File workDir;

    public LuceneIndexInfoProvider(NodeStore nodeStore, AsyncIndexInfoService asyncInfoService, File workDir) {
        this.nodeStore = (NodeStore)Preconditions.checkNotNull((Object)nodeStore);
        this.asyncInfoService = (AsyncIndexInfoService)Preconditions.checkNotNull((Object)asyncInfoService);
        this.workDir = (File)Preconditions.checkNotNull((Object)workDir);
    }

    public String getType() {
        return "lucene";
    }

    public IndexInfo getInfo(String indexPath) throws IOException {
        NodeState idxState = NodeStateUtils.getNode((NodeState)this.nodeStore.getRoot(), (String)indexPath);
        Preconditions.checkArgument((boolean)"lucene".equals(idxState.getString("type")), (String)"Index definition at [%s] is not of type 'lucene'", (Object[])new Object[]{indexPath});
        LuceneIndexInfo info = new LuceneIndexInfo(indexPath);
        this.computeSize(idxState, info);
        LuceneIndexInfoProvider.computeIndexDefinitionChange(idxState, info);
        LuceneIndexInfoProvider.computeLastUpdatedTime(idxState, info);
        this.computeAsyncIndexInfo(idxState, indexPath, info);
        return info;
    }

    public boolean isValid(String indexPath) throws IOException {
        IndexConsistencyChecker checker = new IndexConsistencyChecker(this.nodeStore.getRoot(), indexPath, this.workDir);
        boolean result = false;
        try {
            result = checker.check((IndexConsistencyChecker.Level)IndexConsistencyChecker.Level.BLOBS_ONLY).clean;
        }
        catch (Exception e) {
            this.log.warn("Error occurred while performing consistency check for {}", (Object)indexPath, (Object)e);
        }
        return result;
    }

    private void computeAsyncIndexInfo(NodeState idxState, String indexPath, LuceneIndexInfo info) {
        String asyncName = IndexUtils.getAsyncLaneName((NodeState)idxState, (String)indexPath);
        if (asyncName == null) {
            this.log.warn("No 'async' value for index definition at [{}]. Definition {}", (Object)indexPath, (Object)idxState);
            return;
        }
        AsyncIndexInfo asyncInfo = this.asyncInfoService.getInfo(asyncName);
        Preconditions.checkNotNull((Object)asyncInfo, (String)"No async info found for name [%s] for index at [%s]", (Object[])new Object[]{asyncName, indexPath});
        info.indexedUptoTime = asyncInfo.getLastIndexedTo();
        info.asyncName = asyncName;
    }

    private void computeSize(NodeState idxState, LuceneIndexInfo info) throws IOException {
        IndexDefinition defn = IndexDefinition.newBuilder(this.nodeStore.getRoot(), idxState, info.indexPath).build();
        for (String dirName : idxState.getChildNodeNames()) {
            if (!NodeStateUtils.isHidden((String)dirName) || !MultiplexersLucene.isIndexDirName(dirName)) continue;
            OakDirectory dir = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(idxState), dirName, defn, true);
            Throwable throwable = null;
            try {
                info.numEntries += (long)DirectoryUtils.getNumDocs(dir);
                info.size = DirectoryUtils.dirSize(dir);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dir == null) continue;
                if (throwable != null) {
                    try {
                        ((Directory)dir).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Directory)dir).close();
            }
        }
    }

    private static void computeLastUpdatedTime(NodeState idxState, LuceneIndexInfo info) {
        PropertyState updatedTime;
        NodeState status = idxState.getChildNode(":status");
        if (status.exists() && (updatedTime = status.getProperty("lastUpdated")) != null) {
            info.lastUpdatedTime = ISO8601.parse((String)((String)updatedTime.getValue(Type.DATE))).getTimeInMillis();
        }
    }

    private static void computeIndexDefinitionChange(NodeState idxState, LuceneIndexInfo info) {
        NodeState currentDefn;
        NodeState storedDefn = idxState.getChildNode(":index-definition");
        if (storedDefn.exists() && !FilteringEqualsDiff.equals(storedDefn, currentDefn = NodeStateCloner.cloneVisibleState(idxState))) {
            info.indexDefinitionChanged = true;
            info.indexDiff = JsopDiff.diffToJsop((NodeState)storedDefn, (NodeState)currentDefn);
        }
    }

    static class FilteringEqualsDiff
    extends EqualsDiff {
        private static final Set<String> IGNORED_PROP_NAMES = ImmutableSet.of((Object)"reindexCount", (Object)"reindex");

        FilteringEqualsDiff() {
        }

        public static boolean equals(NodeState before, NodeState after) {
            return before.exists() == after.exists() && after.compareAgainstBaseState(before, (NodeStateDiff)new FilteringEqualsDiff());
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.ignoredProp(before.getName());
        }

        public boolean propertyAdded(PropertyState after) {
            if (this.ignoredProp(after.getName())) {
                return true;
            }
            return super.propertyAdded(after);
        }

        public boolean propertyDeleted(PropertyState before) {
            if (this.ignoredProp(before.getName())) {
                return true;
            }
            return super.propertyDeleted(before);
        }

        private boolean ignoredProp(String name) {
            return IGNORED_PROP_NAMES.contains(name) || NodeStateUtils.isHidden((String)name);
        }
    }

    private static class LuceneIndexInfo
    implements IndexInfo {
        String indexPath;
        String asyncName;
        long numEntries;
        long size;
        long indexedUptoTime;
        long lastUpdatedTime;
        boolean indexDefinitionChanged;
        String indexDiff;

        public LuceneIndexInfo(String indexPath) {
            this.indexPath = indexPath;
        }

        public String getIndexPath() {
            return this.indexPath;
        }

        public String getType() {
            return "lucene";
        }

        public String getAsyncLaneName() {
            return this.asyncName;
        }

        public long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public long getIndexedUpToTime() {
            return this.indexedUptoTime;
        }

        public long getEstimatedEntryCount() {
            return this.numEntries;
        }

        public long getSizeInBytes() {
            return this.size;
        }

        public boolean hasIndexDefinitionChangedWithoutReindexing() {
            return this.indexDefinitionChanged;
        }

        public String getIndexDefinitionDiff() {
            return this.indexDiff;
        }
    }
}

