/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ReindexOperations {
    private final NodeState root;
    private final NodeBuilder definitionBuilder;
    private final String indexPath;

    public ReindexOperations(NodeState root, NodeBuilder definitionBuilder, String indexPath) {
        this.root = root;
        this.definitionBuilder = definitionBuilder;
        this.indexPath = indexPath;
    }

    public IndexDefinition apply(boolean useStateFromBuilder) {
        NodeState defnState;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", (Object)version.getVersion());
        NodeState nodeState = defnState = useStateFromBuilder ? this.definitionBuilder.getNodeState() : this.definitionBuilder.getBaseState();
        if (!IndexDefinition.isDisableStoredIndexDefinition()) {
            this.definitionBuilder.setChildNode(":index-definition", NodeStateCloner.cloneVisibleState(defnState));
        }
        String uid = LuceneIndexEditorContext.configureUniqueId(this.definitionBuilder);
        return IndexDefinition.newBuilder(this.root, defnState, this.indexPath).version(version).uid(uid).reindex().build();
    }
}

