/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOnReadDirectory
extends FilterDirectory {
    private static final Logger log = LoggerFactory.getLogger(CopyOnReadDirectory.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(log.getName() + ".perf")));
    private final IndexCopier indexCopier;
    private final Directory remote;
    private final Directory local;
    private final String indexPath;
    private final Executor executor;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ConcurrentMap<String, CORFileReference> files = Maps.newConcurrentMap();
    private final Set<String> localFileNames = Sets.newConcurrentHashSet();

    public CopyOnReadDirectory(IndexCopier indexCopier, Directory remote, Directory local, boolean prefetch, String indexPath, Executor executor) throws IOException {
        super(remote);
        this.indexCopier = indexCopier;
        this.executor = executor;
        this.remote = remote;
        this.local = local;
        this.indexPath = indexPath;
        this.localFileNames.addAll(Arrays.asList(local.listAll()));
        this.localFileNames.removeAll(indexCopier.getIndexFilesBeingWritten(indexPath));
        if (prefetch) {
            this.prefetchIndexFiles();
        }
    }

    @Override
    public void deleteFile(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot delete in a ReadOnly directory");
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        throw new UnsupportedOperationException("Cannot write in a ReadOnly directory");
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        if (IndexCopier.REMOTE_ONLY.contains(name)) {
            log.trace("[{}] opening remote only file {}", (Object)this.indexPath, (Object)name);
            return this.remote.openInput(name, context);
        }
        CORFileReference ref = (CORFileReference)this.files.get(name);
        if (ref != null) {
            if (ref.isLocalValid()) {
                log.trace("[{}] opening existing local file {}", (Object)this.indexPath, (Object)name);
                return ((CORFileReference)this.files.get(name)).openLocalInput(context);
            }
            this.indexCopier.readFromRemote(true);
            log.trace("[{}] opening existing remote file as local version is not valid {}", (Object)this.indexPath, (Object)name);
            return this.remote.openInput(name, context);
        }
        if (!this.remote.fileExists(name)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Looking for non existent file {}. Current known files {}", new Object[]{this.indexPath, name, Arrays.toString(this.remote.listAll())});
            }
            return this.remote.openInput(name, context);
        }
        CORFileReference toPut = new CORFileReference(name);
        CORFileReference old = this.files.putIfAbsent(name, toPut);
        if (old == null) {
            log.trace("[{}] scheduled local copy for {}", (Object)this.indexPath, (Object)name);
            this.copy(toPut);
        }
        if (toPut.isLocalValid()) {
            log.trace("[{}] opening new local file {}", (Object)this.indexPath, (Object)name);
            return toPut.openLocalInput(context);
        }
        log.trace("[{}] opening new remote file {}", (Object)this.indexPath, (Object)name);
        this.indexCopier.readFromRemote(true);
        return this.remote.openInput(name, context);
    }

    public Directory getLocal() {
        return this.local;
    }

    private void copy(final CORFileReference reference) {
        this.indexCopier.scheduledForCopy();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                CopyOnReadDirectory.this.indexCopier.copyDone();
                CopyOnReadDirectory.this.copyFilesToLocal(reference, true, true);
            }
        });
    }

    private void prefetchIndexFiles() throws IOException {
        long start = PERF_LOGGER.start();
        long totalSize = 0L;
        int copyCount = 0;
        ArrayList copiedFileNames = Lists.newArrayList();
        for (String name : this.remote.listAll()) {
            if (IndexCopier.REMOTE_ONLY.contains(name)) continue;
            CORFileReference fileRef = new CORFileReference(name);
            this.files.putIfAbsent(name, fileRef);
            long fileSize = this.copyFilesToLocal(fileRef, false, false);
            if (fileSize <= 0L) continue;
            ++copyCount;
            totalSize += fileSize;
            copiedFileNames.add(name);
        }
        this.local.sync(copiedFileNames);
        PERF_LOGGER.end(start, -1L, "[{}] Copied {} files totaling {}", new Object[]{this.indexPath, copyCount, IOUtils.humanReadableByteCount((long)totalSize)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long copyFilesToLocal(CORFileReference reference, boolean sync, boolean logDuration) {
        long fileSize;
        block23: {
            String name = reference.name;
            boolean success = false;
            boolean copyAttempted = false;
            fileSize = 0L;
            if (!this.local.fileExists(name)) {
                long perfStart = -1L;
                if (logDuration) {
                    perfStart = PERF_LOGGER.start();
                }
                fileSize = this.remote.fileLength(name);
                LocalIndexFile file = new LocalIndexFile(this.local, name, fileSize, true);
                long start = this.indexCopier.startCopy(file);
                copyAttempted = true;
                this.remote.copy(this.local, name, name, IOContext.READ);
                reference.markValid();
                if (sync) {
                    this.local.sync(Collections.singleton(name));
                }
                this.indexCopier.doneCopy(file, start);
                if (logDuration) {
                    PERF_LOGGER.end(perfStart, 0L, "[{}] Copied file {} of size {}", new Object[]{this.indexPath, name, IOUtils.humanReadableByteCount((long)fileSize)});
                }
            } else {
                long remoteLength;
                long localLength = this.local.fileLength(name);
                if (localLength != (remoteLength = this.remote.fileLength(name))) {
                    LocalIndexFile file = new LocalIndexFile(this.local, name, remoteLength, true);
                    if (!this.indexCopier.isCopyInProgress(file)) {
                        log.warn("[{}] Found local copy for {} in {} but size of local {} differs from remote {}. Content would be read from remote file only", new Object[]{this.indexPath, name, this.local, localLength, remoteLength});
                        this.indexCopier.foundInvalidFile();
                    } else {
                        log.trace("[{}] Found in progress copy of file {}. Would read from remote", (Object)this.indexPath, (Object)name);
                    }
                } else {
                    reference.markValid();
                    log.trace("[{}] found local copy of file {}", (Object)this.indexPath, (Object)name);
                }
            }
            success = true;
            if (!copyAttempted || success) break block23;
            try {
                if (this.local.fileExists(name)) {
                    this.local.deleteFile(name);
                }
                break block23;
            }
            catch (IOException e) {
                log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e});
            }
            break block23;
            catch (IOException e) {
                try {
                    log.warn("[{}] Error occurred while copying file [{}] from {} to {}", new Object[]{this.indexPath, name, this.remote, this.local, e});
                    if (!copyAttempted || success) break block23;
                }
                catch (Throwable throwable) {
                    if (copyAttempted && !success) {
                        try {
                            if (this.local.fileExists(name)) {
                                this.local.deleteFile(name);
                            }
                        }
                        catch (IOException e2) {
                            log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e2});
                        }
                    }
                    throw throwable;
                }
                try {
                    if (this.local.fileExists(name)) {
                        this.local.deleteFile(name);
                    }
                }
                catch (IOException e3) {
                    log.warn("[{}] Error occurred while deleting corrupted file [{}] from [{}]", new Object[]{this.indexPath, name, this.local, e3});
                }
            }
        }
        return fileSize;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CopyOnReadDirectory.this.removeDeletedFiles();
                }
                catch (IOException e) {
                    log.warn("[{}] Error occurred while removing deleted files from Local {}, Remote {}", new Object[]{CopyOnReadDirectory.this.indexPath, CopyOnReadDirectory.this.local, CopyOnReadDirectory.this.remote, e});
                }
                try {
                    CopyOnReadDirectory.this.local.close();
                    CopyOnReadDirectory.this.remote.close();
                }
                catch (IOException e) {
                    log.warn("[{}] Error occurred while closing directory ", (Object)CopyOnReadDirectory.this.indexPath, (Object)e);
                }
            }
        });
    }

    @Override
    public String toString() {
        return String.format("[COR] Local %s, Remote %s", this.local, this.remote);
    }

    private void removeDeletedFiles() throws IOException {
        Object filesToBeDeleted = Sets.difference((Set)ImmutableSet.copyOf(this.localFileNames), (Set)ImmutableSet.copyOf((Object[])this.remote.listAll()));
        HashSet failedToDelete = Sets.newHashSet();
        Iterator iterator = filesToBeDeleted.iterator();
        while (iterator.hasNext()) {
            String fileName = (String)iterator.next();
            boolean deleted = this.indexCopier.deleteFile(this.local, fileName, true);
            if (deleted) continue;
            failedToDelete.add(fileName);
        }
        filesToBeDeleted = new HashSet(filesToBeDeleted);
        filesToBeDeleted.removeAll(failedToDelete);
        if (!filesToBeDeleted.isEmpty()) {
            log.debug("[{}] Following files have been removed from Lucene index directory {}", (Object)this.indexPath, filesToBeDeleted);
        }
    }

    private class CORFileReference {
        final String name;
        private volatile boolean valid;

        private CORFileReference(String name) {
            this.name = name;
        }

        boolean isLocalValid() {
            return this.valid;
        }

        IndexInput openLocalInput(IOContext context) throws IOException {
            CopyOnReadDirectory.this.indexCopier.readFromLocal(true);
            return CopyOnReadDirectory.this.local.openInput(this.name, context);
        }

        void markValid() {
            this.valid = true;
            CopyOnReadDirectory.this.localFileNames.add(this.name);
        }
    }
}

