/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexMeta;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;

public class FSDirectoryFactory
implements DirectoryFactory {
    private final File baseDir;

    public FSDirectoryFactory(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public Directory newInstance(IndexDefinition definition, NodeBuilder builder, String dirName, boolean reindex) throws IOException {
        File indexDir = DirectoryUtils.createIndexDir(this.baseDir, definition.getIndexPath());
        File readMe = new File(indexDir, "index-details.txt");
        File subDir = DirectoryUtils.createSubDir(indexDir, dirName);
        FileUtils.forceMkdir((File)subDir);
        IndexMeta meta = !readMe.exists() ? new IndexMeta(definition.getIndexPath()) : new IndexMeta(readMe);
        meta.addDirectoryMapping(dirName, subDir.getName());
        DirectoryUtils.writeMeta(indexDir, meta);
        return FSDirectory.open(subDir, NoLockFactory.getNoLockFactory());
    }

    @Override
    public boolean remoteDirectory() {
        return false;
    }
}

