/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

final class IndexMeta
implements Comparable<IndexMeta> {
    public static final String DIR_PREFIX = "dir.";
    final String indexPath;
    final long creationTime;
    final int metaFormatVersion = 1;
    private final Map<String, String> properties;

    public IndexMeta(String indexPath) {
        this(indexPath, System.currentTimeMillis(), Collections.emptyMap());
    }

    public IndexMeta(String indexPath, long creationTime) {
        this(indexPath, creationTime, Collections.emptyMap());
    }

    public IndexMeta(String indexPath, long creationTime, Map<String, String> properties) {
        this.indexPath = indexPath;
        this.creationTime = creationTime;
        this.properties = new HashMap<String, String>(properties);
    }

    public IndexMeta(File file) throws IOException {
        Properties p = IndexMeta.loadFromFile(file);
        this.indexPath = (String)Preconditions.checkNotNull((Object)p.getProperty("indexPath"));
        this.creationTime = Long.valueOf((String)Preconditions.checkNotNull((Object)p.getProperty("creationTime")));
        this.properties = new HashMap<String, String>((Map<String, String>)Maps.fromProperties((Properties)p));
    }

    public void addDirectoryMapping(String jcrDirName, String fsDirName) {
        this.properties.put(IndexMeta.keyFromFSDirName(fsDirName), jcrDirName);
    }

    @CheckForNull
    public String getJcrNameFromFSName(String fsDirName) {
        String nameKey = IndexMeta.keyFromFSDirName(fsDirName);
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            if (!nameKey.equals(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    @CheckForNull
    public String getFSNameFromJCRName(String jcrDirName) {
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            if (!e.getKey().startsWith(DIR_PREFIX) || !jcrDirName.equals(e.getValue())) continue;
            return e.getKey().substring(DIR_PREFIX.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        Properties p = new Properties();
        p.putAll(this.properties);
        p.setProperty("metaFormatVersion", String.valueOf(1));
        p.setProperty("indexPath", this.indexPath);
        p.setProperty("creationTime", String.valueOf(this.creationTime));
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            p.store(os, "Index metadata");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    @Override
    public int compareTo(IndexMeta o) {
        return Long.compare(this.creationTime, o.creationTime);
    }

    public String toString() {
        return String.format("%s, %tc", this.indexPath, this.creationTime);
    }

    private static String keyFromFSDirName(String fsDirName) {
        return DIR_PREFIX + fsDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadFromFile(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = FileUtils.openInputStream((File)file);
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

