/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;

public final class LocalIndexFile {
    final File dir;
    final String name;
    final long size;
    final boolean copyFromRemote;
    private volatile int deleteAttemptCount;
    final long creationTime = System.currentTimeMillis();

    public LocalIndexFile(Directory dir, String fileName, long size, boolean copyFromRemote) {
        this.copyFromRemote = copyFromRemote;
        this.dir = LocalIndexFile.getFSDir(dir);
        this.name = fileName;
        this.size = size;
    }

    public LocalIndexFile(Directory dir, String fileName) {
        this(dir, fileName, DirectoryUtils.getFileLength(dir, fileName), true);
    }

    public String getKey() {
        if (this.dir != null) {
            return new File(this.dir, this.name).getAbsolutePath();
        }
        return this.name;
    }

    public boolean isCopyFromRemote() {
        return this.copyFromRemote;
    }

    public long getSize() {
        return this.size;
    }

    public void incrementAttemptToDelete() {
        ++this.deleteAttemptCount;
    }

    public int getDeleteAttemptCount() {
        return this.deleteAttemptCount;
    }

    public String deleteLog() {
        return String.format("%s (%s, %d attempts, %d s)", this.name, IOUtils.humanReadableByteCount((long)this.size), this.deleteAttemptCount, this.timeTaken());
    }

    public String copyLog() {
        return String.format("%s (%s, %1.1f%%, %s, %d s)", this.name, IOUtils.humanReadableByteCount((long)this.actualSize()), Float.valueOf(this.copyProgress()), IOUtils.humanReadableByteCount((long)this.size), this.timeTaken());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalIndexFile localIndexFile = (LocalIndexFile)o;
        if (this.dir != null ? !this.dir.equals(localIndexFile.dir) : localIndexFile.dir != null) {
            return false;
        }
        return this.name.equals(localIndexFile.name);
    }

    public int hashCode() {
        int result = this.dir != null ? this.dir.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    private long timeTaken() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.creationTime);
    }

    private float copyProgress() {
        return (float)this.actualSize() * 1.0f / (float)this.size * 100.0f;
    }

    private long actualSize() {
        return this.dir != null ? new File(this.dir, this.name).length() : 0L;
    }

    static File getFSDir(Directory dir) {
        if (dir instanceof FilterDirectory) {
            dir = ((FilterDirectory)dir).getDelegate();
        }
        if (dir instanceof FSDirectory) {
            return ((FSDirectory)dir).getDirectory();
        }
        return null;
    }
}

