/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexUpdateListener;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.stats.Clock;

public class RefreshOnReadPolicy
implements ReaderRefreshPolicy,
IndexUpdateListener {
    private final AtomicBoolean dirty = new AtomicBoolean();
    private final Object lock = new Object();
    private final Clock clock;
    private final long refreshDelta;
    private volatile long lastRefreshTime;

    public RefreshOnReadPolicy(Clock clock, TimeUnit unit, long refreshDelta) {
        this.clock = clock;
        this.refreshDelta = unit.toMillis(refreshDelta);
    }

    @Override
    public void refreshOnReadIfRequired(Runnable refreshCallback) {
        if (this.dirty.get()) {
            this.refreshWithLock(refreshCallback, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshOnWriteIfRequired(Runnable refreshCallback) {
        long currentTime = this.clock.getTime();
        if (currentTime - this.lastRefreshTime > this.refreshDelta) {
            this.refreshWithLock(refreshCallback, true);
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.dirty.set(true);
            }
        }
    }

    @Override
    public void updated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshWithLock(Runnable refreshCallback, boolean forceRefresh) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dirty.get() || forceRefresh) {
                refreshCallback.run();
                this.dirty.set(false);
                this.lastRefreshTime = this.clock.getTime();
            }
        }
    }
}

