/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexUpdateListener;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.stats.Clock;

public class TimedRefreshPolicy
implements ReaderRefreshPolicy,
IndexUpdateListener {
    private final AtomicBoolean dirty = new AtomicBoolean();
    private final Clock clock;
    private final long refreshDelta;
    private volatile long lastRefreshTime;

    public TimedRefreshPolicy(Clock clock, TimeUnit unit, long refreshDelta) {
        this.clock = clock;
        this.refreshDelta = unit.toMillis(refreshDelta);
    }

    @Override
    public void refreshOnReadIfRequired(Runnable refreshCallback) {
        this.refreshIfRequired(refreshCallback);
    }

    @Override
    public void refreshOnWriteIfRequired(Runnable refreshCallback) {
        this.refreshIfRequired(refreshCallback);
    }

    @Override
    public void updated() {
        this.dirty.set(true);
    }

    private void refreshIfRequired(Runnable refreshCallback) {
        long currentTime;
        if (this.dirty.get() && (currentTime = this.clock.getTime()) - this.lastRefreshTime > this.refreshDelta && this.dirty.compareAndSet(true, false)) {
            this.lastRefreshTime = currentTime;
            refreshCallback.run();
        }
    }
}

