/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import org.apache.jackrabbit.oak.spi.state.NodeState;

class HybridPropertyIndexUtil {
    static final String PROPERTY_INDEX = ":property-index";
    static final String PROP_HEAD_BUCKET = "head";
    static final String PROP_PREVIOUS_BUCKET = "previous";
    static final String PROP_ASYNC_INDEXED_TO_TIME_AT_SWITCH = "asyncIndexedToTimeAtSwitch";
    static final String PROP_CREATED = "jcr:created";
    static final String PROP_STORAGE_TYPE = "storageType";
    static final String STORAGE_TYPE_CONTENT_MIRROR = "contentMirror";
    static final String STORAGE_TYPE_UNIQUE = "unique";

    HybridPropertyIndexUtil() {
    }

    static String getNodeName(String propertyRelativePath) {
        return propertyRelativePath.replace('/', '_');
    }

    static boolean simplePropertyIndex(NodeState propIdxState) {
        return STORAGE_TYPE_CONTENT_MIRROR.equals(propIdxState.getString(PROP_STORAGE_TYPE));
    }

    static boolean uniquePropertyIndex(NodeState propIdxState) {
        return STORAGE_TYPE_UNIQUE.equals(propIdxState.getString(PROP_STORAGE_TYPE));
    }
}

