/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ConfigUtil {
    public static boolean getOptionalValue(NodeState definition, String propName, boolean defaultVal) {
        PropertyState ps = definition.getProperty(propName);
        return ps == null ? defaultVal : (Boolean)ps.getValue(Type.BOOLEAN);
    }

    public static int getOptionalValue(NodeState definition, String propName, int defaultVal) {
        PropertyState ps = definition.getProperty(propName);
        return ps == null ? defaultVal : Ints.checkedCast((long)((Long)ps.getValue(Type.LONG)));
    }

    public static String getOptionalValue(NodeState definition, String propName, String defaultVal) {
        PropertyState ps = definition.getProperty(propName);
        return ps == null ? defaultVal : (String)ps.getValue(Type.STRING);
    }

    public static float getOptionalValue(NodeState definition, String propName, float defaultVal) {
        PropertyState ps = definition.getProperty(propName);
        return ps == null ? defaultVal : ((Double)ps.getValue(Type.DOUBLE)).floatValue();
    }

    public static double getOptionalValue(NodeState definition, String propName, double defaultVal) {
        PropertyState ps = definition.getProperty(propName);
        return ps == null ? defaultVal : (Double)ps.getValue(Type.DOUBLE);
    }

    public static String getPrimaryTypeName(NodeState nodeState) {
        PropertyState ps = nodeState.getProperty("jcr:primaryType");
        return ps == null ? "nt:base" : (String)ps.getValue(Type.NAME);
    }

    public static Iterable<String> getMixinNames(NodeState nodeState) {
        PropertyState ps = nodeState.getProperty("jcr:mixinTypes");
        return ps == null ? Collections.emptyList() : (Iterable)ps.getValue(Type.NAMES);
    }

    public static Blob getBlob(NodeState state, String resourceName) {
        NodeState contentNode = state.getChildNode("jcr:content");
        Preconditions.checkArgument((boolean)contentNode.exists(), (String)"Was expecting to find jcr:content node to read resource %s", (Object[])new Object[]{resourceName});
        return (Blob)contentNode.getProperty("jcr:data").getValue(Type.BINARY);
    }
}

