/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;

class FilteredSortedSetDocValuesFacetCounts
extends SortedSetDocValuesFacetCounts {
    private final TopDocs docs;
    private final Filter filter;
    private final IndexReader reader;
    private final SortedSetDocValuesReaderState state;

    public FilteredSortedSetDocValuesFacetCounts(DefaultSortedSetDocValuesReaderState state, FacetsCollector facetsCollector, Filter filter, TopDocs docs) throws IOException {
        super(state, facetsCollector);
        this.reader = state.origReader;
        this.filter = filter;
        this.docs = docs;
        this.state = state;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        FacetResult topChildren = super.getTopChildren(topN, dim, path);
        if (topChildren == null) {
            return null;
        }
        LabelAndValue[] labelAndValues = topChildren.labelValues;
        for (ScoreDoc scoreDoc : this.docs.scoreDocs) {
            labelAndValues = this.filterFacet(scoreDoc.doc, dim, labelAndValues);
        }
        int childCount = labelAndValues.length;
        Number value = 0;
        for (LabelAndValue lv : labelAndValues) {
            value = ((Number)value).longValue() + lv.value.longValue();
        }
        return new FacetResult(dim, path, value, labelAndValues, childCount);
    }

    private LabelAndValue[] filterFacet(int docId, String dimension, LabelAndValue[] labelAndValues) throws IOException {
        LabelAndValue[] filteredLVs;
        boolean filterd = false;
        HashMap<String, Long> newValues = new HashMap<String, Long>();
        Document document = this.reader.document(docId);
        SortedSetDocValues docValues = this.state.getDocValues();
        docValues.setDocument(docId);
        if (!this.filter.isAccessible(document.getField(":path").stringValue() + "/" + dimension)) {
            filterd = true;
            for (LabelAndValue lv : labelAndValues) {
                long existingCount = lv.value.longValue();
                BytesRef key = new BytesRef(FacetsConfig.pathToString(dimension, new String[]{lv.label}));
                long l = docValues.lookupTerm(key);
                if (l < 0L) continue;
                if (existingCount > 0L) {
                    newValues.put(lv.label, existingCount - 1L);
                    continue;
                }
                if (!newValues.containsKey(lv.label)) continue;
                newValues.remove(lv.label);
            }
        }
        if (filterd) {
            filteredLVs = new LabelAndValue[newValues.size()];
            int i = 0;
            for (Map.Entry entry : newValues.entrySet()) {
                filteredLVs[i] = new LabelAndValue((String)entry.getKey(), (Number)entry.getValue());
                ++i;
            }
        } else {
            filteredLVs = labelAndValues;
        }
        return filteredLVs;
    }
}

