/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.util.HashMap;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;

public class IndexWriterUtils {
    public static IndexWriterConfig getIndexWriterConfig(IndexDefinition definition, boolean remoteDir) {
        return IndexWriterUtils.getIndexWriterConfig(definition, remoteDir, new LuceneIndexWriterConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexWriterConfig getIndexWriterConfig(IndexDefinition definition, boolean remoteDir, LuceneIndexWriterConfig writerConfig) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            Analyzer definitionAnalyzer = definition.getAnalyzer();
            HashMap<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
            analyzers.put(":spellcheck", new ShingleAnalyzerWrapper(LuceneIndexConstants.ANALYZER, 3));
            if (!definition.isSuggestAnalyzed()) {
                analyzers.put(":suggest", SuggestHelper.getAnalyzer());
            }
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper(definitionAnalyzer, analyzers);
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, analyzer);
            if (remoteDir) {
                config.setMergeScheduler(new SerialMergeScheduler());
            }
            if (definition.getCodec() != null) {
                config.setCodec(definition.getCodec());
            }
            config.setRAMBufferSizeMB(writerConfig.getRamBufferSizeMB());
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }
}

