/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import org.apache.jackrabbit.oak.spi.mount.Mount;

public final class MultiplexersLucene {
    public static final String INDEX_DIR_SUFFIX = "-index-data";
    public static final String SUGGEST_DIR_SUFFIX = "-suggest-data";

    public static String getIndexDirName(Mount mount) {
        if (mount.isDefault()) {
            return ":data";
        }
        String name = mount.getPathFragmentName();
        return ":" + name + INDEX_DIR_SUFFIX;
    }

    public static boolean isIndexDirName(String name) {
        return name.endsWith(INDEX_DIR_SUFFIX) || name.equals(":data");
    }

    public static String getSuggestDirName(Mount mount) {
        if (mount.isDefault()) {
            return ":suggest-data";
        }
        String name = mount.getPathFragmentName();
        return ":" + name + SUGGEST_DIR_SUFFIX;
    }

    public static boolean isSuggestIndexDirName(String name) {
        return name.endsWith(SUGGEST_DIR_SUFFIX) || name.equals(":suggest-data");
    }
}

