/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AddContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(AddContentRemoteOperation.class);
    private final String path;

    public AddContentRemoteOperation(String path) {
        this.path = path;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'add' operation on path={}", (Object)this.path);
        Tree tree = root.getTree(this.path);
        if (tree.exists()) {
            throw new RemoteCommitException("node already exists");
        }
        Tree parent = tree.getParent();
        if (!parent.exists()) {
            throw new RemoteCommitException("parent node does not exist");
        }
        parent.addChild(tree.getName());
    }
}

