/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.remote.RemoteLoginException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteCredentials;

class BasicContentRemoteCredentials
implements ContentRemoteCredentials {
    private final String user;
    private final char[] password;

    public BasicContentRemoteCredentials(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public ContentSession login(ContentRepository repository) throws RemoteLoginException {
        ContentSession session;
        try {
            session = repository.login((Credentials)new SimpleCredentials(this.user, this.password), null);
        }
        catch (LoginException e) {
            throw new RemoteLoginException("unable to login", e);
        }
        catch (NoSuchWorkspaceException e) {
            throw new RemoteLoginException("unable to use the default workspace", e);
        }
        return session;
    }
}

