/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.remote.RemoteBinaryFilters;

class ContentRemoteInputStream
extends InputStream {
    private final InputStream stream;
    private final long start;
    private final long count;
    private long index = 0L;

    public ContentRemoteInputStream(InputStream stream, RemoteBinaryFilters filters) {
        this.stream = stream;
        long startFilter = filters.getStart();
        this.start = startFilter > 0L ? startFilter : 0L;
        this.count = filters.getCount();
    }

    @Override
    public int read() throws IOException {
        while (this.index < this.start - 1L) {
            long skipped = this.stream.skip(this.start - this.index);
            if (skipped <= 0L) {
                return -1;
            }
            this.index += skipped;
        }
        if (this.count >= 0L && this.index >= this.start + this.count) {
            return -1;
        }
        int result = this.stream.read();
        ++this.index;
        return result;
    }
}

