/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.remote.RemoteResult;
import org.apache.jackrabbit.oak.remote.RemoteResults;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteResult;

class ContentRemoteResults
implements RemoteResults {
    private final ContentRemoteBinaries binaries;
    private final Result results;

    public ContentRemoteResults(ContentRemoteBinaries binaries, Result results) {
        this.binaries = binaries;
        this.results = results;
    }

    @Override
    public long getTotal() {
        return this.results.getSize();
    }

    @Override
    public Iterable<String> getColumns() {
        return Arrays.asList(this.results.getColumnNames());
    }

    @Override
    public Iterable<String> getSelectors() {
        return Arrays.asList(this.results.getSelectorNames());
    }

    @Override
    public Iterator<RemoteResult> iterator() {
        return this.getResults().iterator();
    }

    private Iterable<RemoteResult> getResults() {
        ArrayList results = Lists.newArrayList();
        for (ResultRow row : this.results.getRows()) {
            results.add(new ContentRemoteResult(this.binaries, row));
        }
        return results;
    }
}

