/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.remote.RemoteTree;
import org.apache.jackrabbit.oak.remote.RemoteTreeFilters;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.oak.remote.filter.Filters;
import org.apache.jackrabbit.util.ISO8601;

class ContentRemoteTree
implements RemoteTree {
    private final Tree tree;
    private final int depth;
    private final RemoteTreeFilters filters;
    private final ContentRemoteBinaries contentRemoteBinaries;

    public ContentRemoteTree(Tree tree, int depth, RemoteTreeFilters filters, ContentRemoteBinaries contentRemoteBinaries) {
        this.tree = tree;
        this.depth = depth;
        this.filters = filters;
        this.contentRemoteBinaries = contentRemoteBinaries;
    }

    @Override
    public Map<String, RemoteValue> getProperties() {
        HashMap<String, RemoteValue> properties = new HashMap<String, RemoteValue>();
        for (PropertyState propertyState : this.getFilteredProperties()) {
            properties.put(propertyState.getName(), this.getRemoteValue(propertyState));
        }
        return properties;
    }

    private Iterable<? extends PropertyState> getFilteredProperties() {
        return Iterables.filter((Iterable)this.tree.getProperties(), this.getPropertyFilters());
    }

    private Predicate<? super PropertyState> getPropertyFilters() {
        return new Predicate<PropertyState>(){

            public boolean apply(PropertyState property) {
                return new Filters(ContentRemoteTree.this.filters.getPropertyFilters()).matches(property.getName());
            }
        };
    }

    private RemoteValue getRemoteValue(PropertyState property) {
        Type type = property.getType();
        if (type == Type.DATE) {
            return RemoteValue.toDate(this.getDate((String)property.getValue(Type.DATE)));
        }
        if (type == Type.DATES) {
            return RemoteValue.toMultiDate(this.getDates((Iterable)property.getValue(Type.DATES)));
        }
        if (type == Type.BINARY) {
            return this.getBinaryRemoteValue((Blob)property.getValue(Type.BINARY));
        }
        if (type == Type.BINARIES) {
            return this.getBinaryRemoteValues((Iterable)property.getValue(Type.BINARIES));
        }
        if (type == Type.BOOLEAN) {
            return RemoteValue.toBoolean((Boolean)property.getValue(Type.BOOLEAN));
        }
        if (type == Type.BOOLEANS) {
            return RemoteValue.toMultiBoolean((Iterable)property.getValue(Type.BOOLEANS));
        }
        if (type == Type.DECIMAL) {
            return RemoteValue.toDecimal((BigDecimal)property.getValue(Type.DECIMAL));
        }
        if (type == Type.DECIMALS) {
            return RemoteValue.toMultiDecimal((Iterable)property.getValue(Type.DECIMALS));
        }
        if (type == Type.DOUBLE) {
            return RemoteValue.toDouble((Double)property.getValue(Type.DOUBLE));
        }
        if (type == Type.DOUBLES) {
            return RemoteValue.toMultiDouble((Iterable)property.getValue(Type.DOUBLES));
        }
        if (type == Type.LONG) {
            return RemoteValue.toLong((Long)property.getValue(Type.LONG));
        }
        if (type == Type.LONGS) {
            return RemoteValue.toMultiLong((Iterable)property.getValue(Type.LONGS));
        }
        if (type == Type.NAME) {
            return RemoteValue.toName((String)property.getValue(Type.NAME));
        }
        if (type == Type.NAMES) {
            return RemoteValue.toMultiName((Iterable)property.getValue(Type.NAMES));
        }
        if (type == Type.PATH) {
            return RemoteValue.toPath((String)property.getValue(Type.PATH));
        }
        if (type == Type.PATHS) {
            return RemoteValue.toMultiPath((Iterable)property.getValue(Type.PATHS));
        }
        if (type == Type.REFERENCE) {
            return RemoteValue.toReference((String)property.getValue(Type.REFERENCE));
        }
        if (type == Type.REFERENCES) {
            return RemoteValue.toMultiReference((Iterable)property.getValue(Type.REFERENCES));
        }
        if (type == Type.STRING) {
            return RemoteValue.toText((String)property.getValue(Type.STRING));
        }
        if (type == Type.STRINGS) {
            return RemoteValue.toMultiText((Iterable)property.getValue(Type.STRINGS));
        }
        if (type == Type.URI) {
            return RemoteValue.toUri((String)property.getValue(Type.URI));
        }
        if (type == Type.URIS) {
            return RemoteValue.toMultiUri((Iterable)property.getValue(Type.URIS));
        }
        if (type == Type.WEAKREFERENCE) {
            return RemoteValue.toWeakReference((String)property.getValue(Type.WEAKREFERENCE));
        }
        if (type == Type.WEAKREFERENCES) {
            return RemoteValue.toMultiWeakReference((Iterable)property.getValue(Type.WEAKREFERENCES));
        }
        throw new IllegalArgumentException("unrecognized property type");
    }

    private long getDate(String date) {
        Calendar calendar = ISO8601.parse((String)date);
        if (calendar == null) {
            throw new IllegalStateException("invalid date format");
        }
        return calendar.getTimeInMillis();
    }

    private Iterable<Long> getDates(Iterable<String> dates) {
        return Iterables.transform(dates, (Function)new Function<String, Long>(){

            public Long apply(String date) {
                return ContentRemoteTree.this.getDate(date);
            }
        });
    }

    private RemoteValue getBinaryRemoteValue(Blob blob) {
        if (this.getLength(blob) < this.filters.getBinaryThreshold()) {
            return RemoteValue.toBinary(this.getBinary(blob));
        }
        return RemoteValue.toBinaryId(this.getBinaryId(blob));
    }

    private RemoteValue getBinaryRemoteValues(Iterable<Blob> blobs) {
        if (this.getLength(blobs) < this.filters.getBinaryThreshold()) {
            return RemoteValue.toMultiBinary(this.getBinaries(blobs));
        }
        return RemoteValue.toMultiBinaryId(this.getBinaryIds(blobs));
    }

    private long getLength(Blob blob) {
        return blob.length();
    }

    private long getLength(Iterable<Blob> blobs) {
        long length = 0L;
        for (Blob blob : blobs) {
            length += blob.length();
        }
        return length;
    }

    private RemoteValue.Supplier<InputStream> getBinary(final Blob blob) {
        return new RemoteValue.Supplier<InputStream>(){

            @Override
            public InputStream get() {
                return blob.getNewStream();
            }
        };
    }

    private Iterable<RemoteValue.Supplier<InputStream>> getBinaries(Iterable<Blob> blobs) {
        return Iterables.transform(blobs, (Function)new Function<Blob, RemoteValue.Supplier<InputStream>>(){

            public RemoteValue.Supplier<InputStream> apply(Blob blob) {
                return ContentRemoteTree.this.getBinary(blob);
            }
        });
    }

    private String getBinaryId(Blob blob) {
        return this.contentRemoteBinaries.put(blob);
    }

    private Iterable<String> getBinaryIds(Iterable<Blob> blobs) {
        return Iterables.transform(blobs, (Function)new Function<Blob, String>(){

            public String apply(Blob blob) {
                return ContentRemoteTree.this.getBinaryId(blob);
            }
        });
    }

    @Override
    public Map<String, RemoteTree> getChildren() {
        HashMap<String, RemoteTree> children = new HashMap<String, RemoteTree>();
        for (Tree child : this.getFilteredChildren()) {
            if (this.depth < this.filters.getDepth()) {
                children.put(child.getName(), new ContentRemoteTree(child, this.depth + 1, this.filters, this.contentRemoteBinaries));
                continue;
            }
            children.put(child.getName(), null);
        }
        return children;
    }

    private Iterable<Tree> getFilteredChildren() {
        Iterable result = this.tree.getChildren();
        if (this.filters.getChildrenStart() > 0) {
            result = Iterables.skip((Iterable)result, (int)this.filters.getChildrenStart());
        }
        if (this.filters.getChildrenCount() >= 0) {
            result = Iterables.limit((Iterable)result, (int)this.filters.getChildrenCount());
        }
        return Iterables.filter((Iterable)result, this.getNodeFilters());
    }

    private Predicate<Tree> getNodeFilters() {
        return new Predicate<Tree>(){

            public boolean apply(Tree child) {
                return new Filters(ContentRemoteTree.this.filters.getNodeFilters()).matches(child.getName());
            }
        };
    }

    @Override
    public boolean hasMoreChildren() {
        int max;
        int count;
        if (this.filters.getChildrenCount() < 0) {
            return false;
        }
        int start = this.filters.getChildrenStart();
        if (start < 0) {
            start = 0;
        }
        if ((count = this.filters.getChildrenCount()) < 0) {
            count = 0;
        }
        return this.tree.getChildrenCount((long)(max = start + count)) > (long)max;
    }
}

