/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.util.ISO8601;

class SetPropertyHandler
extends RemoteValue.TypeHandler {
    private final ContentRemoteBinaries binaries;
    private final Root root;
    private final Tree tree;
    private final String name;

    public SetPropertyHandler(ContentRemoteBinaries binaries, Root root, Tree tree, String name) {
        this.binaries = binaries;
        this.root = root;
        this.tree = tree;
        this.name = name;
    }

    @Override
    public void isBinary(RemoteValue.Supplier<InputStream> value) {
        this.tree.setProperty(this.name, (Object)this.getBlob(this.root, value), Type.BINARY);
    }

    @Override
    public void isMultiBinary(Iterable<RemoteValue.Supplier<InputStream>> value) {
        this.tree.setProperty(this.name, this.getBlobs(this.root, value), Type.BINARIES);
    }

    @Override
    public void isBinaryId(String value) {
        this.tree.setProperty(this.name, (Object)this.getBlobFromId(this.binaries, value), Type.BINARY);
    }

    @Override
    public void isMultiBinaryId(Iterable<String> value) {
        this.tree.setProperty(this.name, this.getBlobsFromIds(this.binaries, value), Type.BINARIES);
    }

    @Override
    public void isBoolean(Boolean value) {
        this.tree.setProperty(this.name, (Object)value, Type.BOOLEAN);
    }

    @Override
    public void isMultiBoolean(Iterable<Boolean> value) {
        this.tree.setProperty(this.name, value, Type.BOOLEANS);
    }

    @Override
    public void isDate(Long value) {
        this.tree.setProperty(this.name, (Object)this.getDate(value), Type.DATE);
    }

    @Override
    public void isMultiDate(Iterable<Long> value) {
        this.tree.setProperty(this.name, this.getDates(value), Type.DATES);
    }

    @Override
    public void isDecimal(BigDecimal value) {
        this.tree.setProperty(this.name, (Object)value, Type.DECIMAL);
    }

    @Override
    public void isMultiDecimal(Iterable<BigDecimal> value) {
        this.tree.setProperty(this.name, value, Type.DECIMALS);
    }

    @Override
    public void isDouble(Double value) {
        this.tree.setProperty(this.name, (Object)value, Type.DOUBLE);
    }

    @Override
    public void isMultiDouble(Iterable<Double> value) {
        this.tree.setProperty(this.name, value, Type.DOUBLES);
    }

    @Override
    public void isLong(Long value) {
        this.tree.setProperty(this.name, (Object)value, Type.LONG);
    }

    @Override
    public void isMultiLong(Iterable<Long> value) {
        this.tree.setProperty(this.name, value, Type.LONGS);
    }

    @Override
    public void isName(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.NAME);
    }

    @Override
    public void isMultiName(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.NAMES);
    }

    @Override
    public void isPath(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.PATH);
    }

    @Override
    public void isMultiPath(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.PATHS);
    }

    @Override
    public void isReference(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.REFERENCE);
    }

    @Override
    public void isMultiReference(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.REFERENCES);
    }

    @Override
    public void isText(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.STRING);
    }

    @Override
    public void isMultiText(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.STRINGS);
    }

    @Override
    public void isUri(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.URI);
    }

    @Override
    public void isMultiUri(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.URIS);
    }

    @Override
    public void isWeakReference(String value) {
        this.tree.setProperty(this.name, (Object)value, Type.WEAKREFERENCE);
    }

    @Override
    public void isMultiWeakReference(Iterable<String> value) {
        this.tree.setProperty(this.name, value, Type.WEAKREFERENCES);
    }

    private Blob getBlob(Root root, RemoteValue.Supplier<InputStream> supplier) {
        Blob blob;
        InputStream inputStream = supplier.get();
        if (inputStream == null) {
            throw new IllegalStateException("invalid input stream");
        }
        try {
            blob = root.createBlob(inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to create a blob", e);
        }
        return blob;
    }

    private Iterable<Blob> getBlobs(final Root root, Iterable<RemoteValue.Supplier<InputStream>> suppliers) {
        return Iterables.transform(suppliers, (Function)new Function<RemoteValue.Supplier<InputStream>, Blob>(){

            public Blob apply(RemoteValue.Supplier<InputStream> supplier) {
                return SetPropertyHandler.this.getBlob(root, supplier);
            }
        });
    }

    private Blob getBlobFromId(ContentRemoteBinaries binaries, String binaryId) {
        return binaries.get(binaryId);
    }

    private Iterable<Blob> getBlobsFromIds(final ContentRemoteBinaries binaries, Iterable<String> binaryIds) {
        return Iterables.transform(binaryIds, (Function)new Function<String, Blob>(){

            public Blob apply(String binaryId) {
                return SetPropertyHandler.this.getBlobFromId(binaries, binaryId);
            }
        });
    }

    private String getDate(Long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return ISO8601.format((Calendar)calendar);
    }

    private Iterable<String> getDates(Iterable<Long> times) {
        return Iterables.transform(times, (Function)new Function<Long, String>(){

            public String apply(Long time) {
                return SetPropertyHandler.this.getDate(time);
            }
        });
    }
}

