/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnsetContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(UnsetContentRemoteOperation.class);
    private final String path;
    private final String name;

    public UnsetContentRemoteOperation(String path, String name) {
        this.path = path;
        this.name = name;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'unset' operation on path={}, name={}", (Object)this.path, (Object)this.name);
        Tree tree = root.getTree(this.path);
        if (!tree.exists()) {
            throw new RemoteCommitException("tree does not exists");
        }
        if (!tree.hasProperty(this.name)) {
            throw new RemoteCommitException("property does not exist");
        }
        tree.removeProperty(this.name);
    }
}

