/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.oak.remote.RemoteRevision;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.HeadTreeHandler;

class HeadLastTreeHandler
extends HeadTreeHandler {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^/revisions/last/tree(/.*)$");

    HeadLastTreeHandler() {
    }

    @Override
    protected String readPath(HttpServletRequest request) {
        Matcher matcher = REQUEST_PATTERN.matcher(request.getPathInfo());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("handler bound at the wrong path");
    }

    @Override
    protected RemoteRevision readRevision(HttpServletRequest request, RemoteSession session) {
        return session.readLastRevision();
    }
}

