/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteBinaryId;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

class PostBinaryHandler
implements Handler {
    PostBinaryHandler() {
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        RemoteBinaryId binaryId = session.writeBinary((InputStream)request.getInputStream());
        response.setStatus(201);
        response.setContentType("application/json");
        ServletOutputStream stream = response.getOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)stream, JsonEncoding.UTF8);
        generator.writeStartObject();
        generator.writeStringField("binaryId", binaryId.asString());
        generator.writeEndObject();
        generator.flush();
        stream.close();
    }
}

