/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.apache.jackrabbit.oak.remote.RemoteValue;

class RemoteValues {
    private RemoteValues() {
    }

    public static void renderJsonOrNull(JsonGenerator generator, RemoteValue value) throws IOException {
        if (value == null) {
            generator.writeNull();
        } else {
            RemoteValues.renderJson(generator, value);
        }
    }

    public static void renderJson(JsonGenerator generator, RemoteValue value) throws IOException {
        if (value.isBinary()) {
            RemoteValues.renderValue(generator, "binary", value.asBinary(), RemoteValues.getBinaryWriter());
        }
        if (value.isMultiBinary()) {
            RemoteValues.renderMultiValue(generator, "binaries", value.asMultiBinary(), RemoteValues.getBinaryWriter());
        }
        if (value.isBinaryId()) {
            RemoteValues.renderValue(generator, "binaryId", value.asBinaryId(), RemoteValues.getStringWriter());
        }
        if (value.isMultiBinaryId()) {
            RemoteValues.renderMultiValue(generator, "binaryIds", value.asMultiBinaryId(), RemoteValues.getStringWriter());
        }
        if (value.isBoolean()) {
            RemoteValues.renderValue(generator, "boolean", value.asBoolean(), RemoteValues.getBooleanWriter());
        }
        if (value.isMultiBoolean()) {
            RemoteValues.renderMultiValue(generator, "booleans", value.asMultiBoolean(), RemoteValues.getBooleanWriter());
        }
        if (value.isDate()) {
            RemoteValues.renderValue(generator, "date", value.asDate(), RemoteValues.getLongWriter());
        }
        if (value.isMultiDate()) {
            RemoteValues.renderMultiValue(generator, "dates", value.asMultiDate(), RemoteValues.getLongWriter());
        }
        if (value.isDecimal()) {
            RemoteValues.renderValue(generator, "decimal", value.asDecimal(), RemoteValues.getDecimalWriter());
        }
        if (value.isMultiDecimal()) {
            RemoteValues.renderMultiValue(generator, "decimals", value.asMultiDecimal(), RemoteValues.getDecimalWriter());
        }
        if (value.isDouble()) {
            RemoteValues.renderValue(generator, "double", value.asDouble(), RemoteValues.getDoubleWriter());
        }
        if (value.isMultiDouble()) {
            RemoteValues.renderMultiValue(generator, "doubles", value.asMultiDouble(), RemoteValues.getDoubleWriter());
        }
        if (value.isLong()) {
            RemoteValues.renderValue(generator, "long", value.asLong(), RemoteValues.getLongWriter());
        }
        if (value.isMultiLong()) {
            RemoteValues.renderMultiValue(generator, "longs", value.asMultiLong(), RemoteValues.getLongWriter());
        }
        if (value.isName()) {
            RemoteValues.renderValue(generator, "name", value.asName(), RemoteValues.getStringWriter());
        }
        if (value.isMultiName()) {
            RemoteValues.renderMultiValue(generator, "names", value.asMultiName(), RemoteValues.getStringWriter());
        }
        if (value.isPath()) {
            RemoteValues.renderValue(generator, "path", value.asPath(), RemoteValues.getStringWriter());
        }
        if (value.isMultiPath()) {
            RemoteValues.renderMultiValue(generator, "paths", value.asMultiPath(), RemoteValues.getStringWriter());
        }
        if (value.isReference()) {
            RemoteValues.renderValue(generator, "reference", value.asReference(), RemoteValues.getStringWriter());
        }
        if (value.isMultiReference()) {
            RemoteValues.renderMultiValue(generator, "references", value.asMultiReference(), RemoteValues.getStringWriter());
        }
        if (value.isText()) {
            RemoteValues.renderValue(generator, "string", value.asText(), RemoteValues.getStringWriter());
        }
        if (value.isMultiText()) {
            RemoteValues.renderMultiValue(generator, "strings", value.asMultiText(), RemoteValues.getStringWriter());
        }
        if (value.isUri()) {
            RemoteValues.renderValue(generator, "uri", value.asUri(), RemoteValues.getStringWriter());
        }
        if (value.isMultiUri()) {
            RemoteValues.renderMultiValue(generator, "uris", value.asMultiUri(), RemoteValues.getStringWriter());
        }
        if (value.isWeakReference()) {
            RemoteValues.renderValue(generator, "weakReference", value.asWeakReference(), RemoteValues.getStringWriter());
        }
        if (value.isMultiWeakReference()) {
            RemoteValues.renderMultiValue(generator, "weakReferences", value.asMultiWeakReference(), RemoteValues.getStringWriter());
        }
    }

    private static GeneratorWriter<RemoteValue.Supplier<InputStream>> getBinaryWriter() {
        return new GeneratorWriter<RemoteValue.Supplier<InputStream>>(){

            @Override
            public void write(JsonGenerator generator, RemoteValue.Supplier<InputStream> value) throws IOException {
                generator.writeString(BaseEncoding.base64().encode(ByteStreams.toByteArray((InputStream)value.get())));
            }
        };
    }

    private static GeneratorWriter<String> getStringWriter() {
        return new GeneratorWriter<String>(){

            @Override
            public void write(JsonGenerator generator, String value) throws IOException {
                generator.writeString(value);
            }
        };
    }

    private static GeneratorWriter<Boolean> getBooleanWriter() {
        return new GeneratorWriter<Boolean>(){

            @Override
            public void write(JsonGenerator generator, Boolean value) throws IOException {
                generator.writeBoolean(value.booleanValue());
            }
        };
    }

    private static GeneratorWriter<Long> getLongWriter() {
        return new GeneratorWriter<Long>(){

            @Override
            public void write(JsonGenerator generator, Long value) throws IOException {
                generator.writeNumber(value.longValue());
            }
        };
    }

    private static GeneratorWriter<BigDecimal> getDecimalWriter() {
        return new GeneratorWriter<BigDecimal>(){

            @Override
            public void write(JsonGenerator generator, BigDecimal value) throws IOException {
                generator.writeString(value.toString());
            }
        };
    }

    private static GeneratorWriter<Double> getDoubleWriter() {
        return new GeneratorWriter<Double>(){

            @Override
            public void write(JsonGenerator generator, Double value) throws IOException {
                generator.writeNumber(value.doubleValue());
            }
        };
    }

    private static <T> void renderValue(JsonGenerator generator, String type, T value, GeneratorWriter<T> writer) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", type);
        generator.writeFieldName("value");
        writer.write(generator, value);
        generator.writeEndObject();
    }

    private static <T> void renderMultiValue(JsonGenerator generator, String type, Iterable<T> values, GeneratorWriter<T> writer) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", type);
        generator.writeArrayFieldStart("value");
        for (T value : values) {
            writer.write(generator, value);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private static interface GeneratorWriter<T> {
        public void write(JsonGenerator var1, T var2) throws IOException;
    }
}

