/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.osgi;

import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.remote.RemoteRepository;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteRepository;
import org.apache.jackrabbit.oak.remote.http.RemoteServlet;
import org.osgi.service.http.HttpService;

@Component(metatype=true, immediate=true, label="Apache Jackrabbit Oak Remote HTTP API", description="The HTTP binding of the Remote API for a Jackrabbit Oak repository")
@Properties(value={@Property(name="url", value={"/api"}, label="Mount URL", description="Where the root application is exposed in the URL namespace")})
public class RemoteServletRegistration {
    @Reference
    private HttpService httpService;
    @Reference
    private ContentRepository contentRepository;

    @Activate
    public void activate(Map properties) {
        this.registerServlet(this.getUrl(properties));
    }

    @Deactivate
    public void deactivate(Map properties) {
        this.unregisterServlet(this.getUrl(properties));
    }

    private void registerServlet(String url) {
        try {
            this.httpService.registerServlet(url, (Servlet)this.getRemoteServlet(), null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unregisterServlet(String url) {
        this.httpService.unregister(url);
    }

    private String getUrl(Map properties) {
        return (String)properties.get("url");
    }

    private RemoteServlet getRemoteServlet() {
        return new RemoteServlet(this.getRemoteRepository());
    }

    private RemoteRepository getRemoteRepository() {
        return new ContentRemoteRepository(this.contentRepository);
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    protected void unbindContentRepository(ContentRepository contentRepository) {
        if (this.contentRepository == contentRepository) {
            this.contentRepository = null;
        }
    }
}

