/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.jts;

import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.io.GeoJSONReader;
import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.noggit.JSONParser;

public class JtsGeoJSONReader
extends GeoJSONReader {
    protected final JtsSpatialContext ctx;

    public JtsGeoJSONReader(JtsSpatialContext ctx, SpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
    }

    public Coordinate readCoord(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        Coordinate coord = new Coordinate();
        int idx = 0;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 2: 
                case 3: 
                case 4: {
                    coord.setOrdinate(idx++, parser.getDouble());
                    break;
                }
                case 10: {
                    return coord;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        return coord;
    }

    public List<Coordinate> readCoordList(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 9: {
                    coords.add(this.readCoord(parser));
                    break;
                }
                case 10: {
                    return coords;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        return coords;
    }

    @Override
    protected Shape readPoint(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        Coordinate coord = this.readCoord(parser);
        return this.ctx.makePoint(coord.x, coord.y);
    }

    @Override
    protected Shape readPolygon(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        GeometryFactory gf = this.ctx.getGeometryFactory();
        return this.ctx.makeShape((Geometry)this.createPolygon(gf, this.readCoordinates(parser)));
    }

    @Override
    protected Shape makeShapeFromCoords(String type, List coords) {
        GeometryFactory gf = this.ctx.getGeometryFactory();
        switch (type) {
            case "Polygon": {
                Polygon polygon = this.createPolygon(gf, coords);
                if (polygon.isRectangle()) {
                    return this.ctx.makeRectFromRectangularPoly((Geometry)polygon);
                }
                return this.ctx.makeShapeFromGeometry((Geometry)polygon);
            }
            case "MultiPoint": {
                return this.ctx.makeShapeFromGeometry((Geometry)this.createMultiPoint(gf, coords));
            }
            case "MultiLineString": {
                return this.ctx.makeShapeFromGeometry((Geometry)this.createMultiLineString(gf, coords));
            }
            case "MultiPolygon": {
                return this.ctx.makeShapeFromGeometry((Geometry)this.createMultiPolygon(gf, coords));
            }
        }
        return null;
    }

    protected Point createPoint(GeometryFactory gf, List list) {
        return gf.createPoint(this.coord(list));
    }

    protected LineString createLineString(GeometryFactory gf, List list) {
        return gf.createLineString(this.coordseq(list));
    }

    protected Polygon createPolygon(GeometryFactory gf, List list) {
        LinearRing shell = gf.createLinearRing(this.coordseq((List)this.ensureSize(list, 1).get(0)));
        LinearRing[] holes = list.size() > 1 ? new LinearRing[list.size() - 1] : null;
        for (int i = 1; i < list.size(); ++i) {
            holes[i - 1] = gf.createLinearRing(this.coordseq((List)list.get(i)));
        }
        return gf.createPolygon(shell, holes);
    }

    protected MultiPoint createMultiPoint(GeometryFactory gf, List list) {
        return gf.createMultiPoint(this.coordseq(list));
    }

    protected MultiLineString createMultiLineString(GeometryFactory gf, List list) {
        LineString[] lines = new LineString[this.ensureSize(list, 1).size()];
        for (int i = 0; i < list.size(); ++i) {
            lines[i] = this.createLineString(gf, (List)list.get(i));
        }
        return gf.createMultiLineString(lines);
    }

    protected MultiPolygon createMultiPolygon(GeometryFactory gf, List list) {
        Polygon[] polys = new Polygon[this.ensureSize(list, 1).size()];
        for (int i = 0; i < list.size(); ++i) {
            polys[i] = this.createPolygon(gf, (List)list.get(i));
        }
        return gf.createMultiPolygon(polys);
    }

    protected GeometryCollection createGeometryCollection(GeometryFactory gf, List geoms) {
        return gf.createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    protected Coordinate coord(List list) {
        this.ensureSize(list, 2);
        double x = this.number(list.get(0));
        double y = this.number(list.get(1));
        double z = list.size() > 2 ? this.number(list.get(2)) : Double.NaN;
        Coordinate c = new Coordinate(x, y);
        if (!Double.isNaN(z)) {
            c.z = z;
        }
        return c;
    }

    protected CoordinateSequence coordseq(List list) {
        this.ensureSize(list, 1);
        int dim = this.ensureSize((List)list.get(0), 2).size();
        CoordinateSequence seq = PackedCoordinateSequenceFactory.DOUBLE_FACTORY.create(list.size(), dim);
        for (int i = 0; i < list.size(); ++i) {
            List c = (List)list.get(i);
            seq.setOrdinate(i, 0, this.number(c.get(0)));
            seq.setOrdinate(i, 1, this.number(c.get(1)));
            if (dim <= 2) continue;
            seq.setOrdinate(i, 2, this.number(c.get(2)));
        }
        return seq;
    }

    protected double number(Object obj) {
        return ((Number)obj).doubleValue();
    }

    protected List ensureSize(List list, int size) {
        if (list.size() < size) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "expected coordinate arary of size %d but is of size %d", size, list.size()));
        }
        return list;
    }
}

