/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateSolrServerConfigurationProvider
implements SolrServerConfigurationProvider {
    private final NodeState nodeState;

    public NodeStateSolrServerConfigurationProvider(NodeState nodeState) {
        this.nodeState = nodeState;
        if (!nodeState.hasProperty("solrServerType")) {
            throw new IllegalArgumentException("missing property solrServerType in " + nodeState);
        }
    }

    private int getIntValueFor(String propertyName, int defaultValue) {
        long value = defaultValue;
        PropertyState property = this.nodeState.getProperty(propertyName);
        if (property != null) {
            value = (Long)property.getValue(Type.LONG);
        }
        return (int)value;
    }

    private String getStringValueFor(String propertyName, String defaultValue) {
        String value = defaultValue;
        PropertyState property = this.nodeState.getProperty(propertyName);
        if (property != null) {
            value = (String)property.getValue(Type.STRING);
        }
        return value;
    }

    @Nonnull
    public SolrServerConfiguration<SolrServerProvider> getSolrServerConfiguration() {
        String type = this.getStringValueFor("solrServerType", null);
        if ("embedded".equalsIgnoreCase(type)) {
            String solrHomePath = this.getStringValueFor("solrHomePath", "solr");
            String coreName = this.getStringValueFor("coreName", "oak");
            String context = this.getStringValueFor("solrContext", null);
            Integer httpPort = Integer.valueOf(this.getStringValueFor("httpPort", "0"));
            if (context != null && httpPort > 0) {
                return new EmbeddedSolrServerConfiguration(solrHomePath, coreName).withHttpConfiguration(context, httpPort);
            }
            return new EmbeddedSolrServerConfiguration(solrHomePath, coreName);
        }
        if ("remote".equalsIgnoreCase(type)) {
            String solrZkHost = this.getStringValueFor("zkHost", null);
            String solrCollection = this.getStringValueFor("collection", "oak");
            int solrReplicationFactor = this.getIntValueFor("replicationFactor", 2);
            String solrConfDir = this.getStringValueFor("configurationDirectory", "");
            String solrHttpUrls = this.getStringValueFor("httpUrl", "http://127.0.0.1:8983/solr/oak");
            int solrShardsNo = this.getIntValueFor("shardsNo", 2);
            int socketTimeout = this.getIntValueFor("socketTimeout", 3000);
            int connectionTimeout = this.getIntValueFor("connectionTimeout", 3000);
            return new RemoteSolrServerConfiguration(solrZkHost, solrCollection, solrShardsNo, solrReplicationFactor, solrConfDir, socketTimeout, connectionTimeout, solrHttpUrls);
        }
        throw new RuntimeException("unexpected Solr server type: " + type);
    }

    public final class Properties {
        public static final String SERVER_TYPE = "solrServerType";
        public static final String SOLRHOME_PATH = "solrHomePath";
        public static final String CONTEXT = "solrContext";
        public static final String HTTP_PORT = "httpPort";
        public static final String CORE_NAME = "coreName";
        public static final String ZK_HOST = "zkHost";
        public static final String COLLECTION = "collection";
        public static final String REPLICATION_FACTOR = "replicationFactor";
        public static final String CONFIGURATION_DIRECTORY = "configurationDirectory";
        public static final String HTTP_URL = "httpUrl";
        public static final String SHARDS_NO = "shardsNo";
        public static final String CONNECTION_TIMEOUT = "connectionTimeout";
        public static final String SOCKET_TIMEOUT = "socketTimeout";
    }
}

