/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.OakSolrNodeStateConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditor;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexEditorProvider
implements IndexEditorProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrServerProvider solrServerProvider;
    private final OakSolrConfigurationProvider oakSolrConfigurationProvider;

    public SolrIndexEditorProvider(@Nonnull SolrServerProvider solrServerProvider, @Nonnull OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.solrServerProvider = solrServerProvider;
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
    }

    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        SolrIndexEditor editor = null;
        if ("solr".equals(type)) {
            try {
                if (this.isPersistedConfiguration(definition)) {
                    NodeState nodeState = definition.getNodeState();
                    OakSolrNodeStateConfiguration configuration = new OakSolrNodeStateConfiguration(nodeState);
                    NodeStateSolrServerConfigurationProvider configurationProvider = new NodeStateSolrServerConfigurationProvider(definition.getChildNode("server").getNodeState());
                    OakSolrServer solrServer = new OakSolrServer(configurationProvider);
                    editor = this.getEditor(configuration, solrServer, callback);
                } else {
                    OakSolrConfiguration configuration = this.oakSolrConfigurationProvider.getConfiguration();
                    editor = this.getEditor(configuration, this.solrServerProvider.getIndexingSolrServer(), callback);
                }
            }
            catch (Exception e) {
                this.log.warn("could not get Solr index editor from {}", (Object)definition.getNodeState(), (Object)e);
            }
        }
        return editor;
    }

    private boolean isPersistedConfiguration(NodeBuilder definition) {
        return definition.hasChildNode("server");
    }

    private SolrIndexEditor getEditor(OakSolrConfiguration configuration, SolrClient solrServer, IndexUpdateCallback callback) {
        SolrIndexEditor editor;
        block5: {
            editor = null;
            try {
                if (solrServer != null) {
                    editor = new SolrIndexEditor(solrServer, configuration, callback);
                } else if (this.log.isWarnEnabled()) {
                    this.log.warn("no SolrServer provided, cannot perform indexing");
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("unable to create SolrIndexEditor", (Throwable)e);
            }
        }
        return editor;
    }
}

