/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.IOException;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class DefaultSolrServerProvider
implements SolrServerProvider {
    private SolrClient solrServer;
    private SolrClient indexingSolrServer;

    @Override
    @CheckForNull
    public SolrClient getSolrServer() throws Exception {
        if (this.solrServer == null) {
            this.solrServer = new HttpSolrServer(this.getUrl());
        }
        return this.solrServer;
    }

    @Override
    @CheckForNull
    public SolrClient getIndexingSolrServer() throws Exception {
        if (this.indexingSolrServer == null) {
            this.indexingSolrServer = new ConcurrentUpdateSolrServer(this.getUrl(), 1000, 4);
        }
        return this.indexingSolrServer;
    }

    @Override
    @CheckForNull
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private String getUrl() {
        return "http://127.0.0.1:8983/solr/oak";
    }

    @Override
    public void close() throws IOException {
        try {
            SolrClient solrServer = this.getSolrServer();
            if (solrServer != null) {
                solrServer.shutdown();
            }
        }
        catch (Exception solrServer) {
            // empty catch block
        }
        try {
            SolrClient indexingSolrServer = this.getIndexingSolrServer();
            if (indexingSolrServer != null) {
                indexingSolrServer.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getSearchingSolrServer().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

