/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public final class GeoEncodingUtils {
    public static final short BITS = 31;
    private static final double LON_SCALE = 5965232.355555556;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    public static final int BUF_SIZE_LONG = 4;
    public static final double TOLERANCE = 1.0E-6;

    private GeoEncodingUtils() {
    }

    public static final Long mortonHash(double lon, double lat) {
        return BitUtil.interleave(GeoEncodingUtils.scaleLon(lon), GeoEncodingUtils.scaleLat(lat));
    }

    public static final double mortonUnhashLon(long hash) {
        return GeoEncodingUtils.unscaleLon(BitUtil.deinterleave(hash));
    }

    public static final double mortonUnhashLat(long hash) {
        return GeoEncodingUtils.unscaleLat(BitUtil.deinterleave(hash >>> 1));
    }

    protected static final long scaleLon(double val) {
        return (long)((val - -180.0) * 5965232.355555556);
    }

    protected static final long scaleLat(double val) {
        return (long)((val - -90.0) * 1.1930464711111112E7);
    }

    protected static final double unscaleLon(long val) {
        return (double)val / 5965232.355555556 + -180.0;
    }

    protected static final double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 + -90.0;
    }

    public static double compare(double v1, double v2) {
        double delta = v1 - v2;
        return Math.abs(delta) <= 1.0E-6 ? 0.0 : delta;
    }

    public static void geoCodedToPrefixCoded(long hash, int shift, BytesRefBuilder bytes) {
        GeoEncodingUtils.geoCodedToPrefixCodedBytes(hash, shift, bytes);
    }

    public static long prefixCodedToGeoCoded(BytesRef val) {
        long result = GeoEncodingUtils.fromBytes((byte)0, (byte)0, (byte)0, (byte)0, val.bytes[val.offset + 0], val.bytes[val.offset + 1], val.bytes[val.offset + 2], val.bytes[val.offset + 3]);
        return result << 32;
    }

    private static void geoCodedToPrefixCodedBytes(long hash, int shift, BytesRefBuilder bytes) {
        if (shift < 32 || shift > 63) {
            throw new IllegalArgumentException("Illegal shift value, must be 32..63; got shift=" + shift);
        }
        int nChars = 5;
        bytes.setLength(nChars);
        bytes.grow(nChars--);
        int sigBits = 64 - shift;
        bytes.setByteAt(4, (byte)sigBits);
        long sortableBits = hash;
        sortableBits >>>= shift;
        sortableBits <<= 32 - sigBits;
        do {
            bytes.setByteAt(--nChars, (byte)sortableBits);
            sortableBits >>>= 8;
        } while (nChars > 0);
    }

    public static int getPrefixCodedShift(BytesRef val) {
        byte shift = val.bytes[val.offset + 4];
        if (shift > 63 || shift < 0) {
            throw new NumberFormatException("Invalid shift value (" + shift + ") in prefixCoded bytes (is encoded value really a geo point?)");
        }
        return shift;
    }

    protected static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    public static String geoTermToString(long term) {
        StringBuilder s = new StringBuilder(64);
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(term);
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            s.append('0');
        }
        if (term != 0L) {
            s.append(Long.toBinaryString(term));
        }
        return s.toString();
    }
}

