/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.SolrHttpRequestRetryHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    public static final String PROP_SO_TIMEOUT = "socketTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "connTimeout";
    public static final String PROP_MAX_CONNECTIONS_PER_HOST = "maxConnectionsPerHost";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_USE_RETRY = "retry";
    public static final String PROP_ALLOW_COMPRESSION = "allowCompression";
    public static final String PROP_FOLLOW_REDIRECTS = "followRedirects";
    public static final String PROP_BASIC_AUTH_USER = "httpBasicAuthUser";
    public static final String PROP_BASIC_AUTH_PASS = "httpBasicAuthPassword";
    public static final String SYS_PROP_CHECK_PEER_NAME = "solr.ssl.checkPeerName";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final DefaultHttpRequestRetryHandler NO_RETRY = new DefaultHttpRequestRetryHandler(0, false);
    private static HttpClientConfigurer configurer = new HttpClientConfigurer();
    private static final List<HttpRequestInterceptor> interceptors = Collections.synchronizedList(new ArrayList());

    public static void setConfigurer(HttpClientConfigurer newConfigurer) {
        configurer = newConfigurer;
    }

    public static HttpClientConfigurer getConfigurer() {
        return configurer;
    }

    public static CloseableHttpClient createClient(SolrParams params) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new http client, config:" + config);
        }
        SystemDefaultHttpClient httpClient = HttpClientFactory.createHttpClient();
        HttpClientUtil.configureClient(httpClient, config);
        return httpClient;
    }

    public static CloseableHttpClient createClient(SolrParams params, ClientConnectionManager cm) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new http client, config:" + config);
        }
        DefaultHttpClient httpClient = HttpClientFactory.createHttpClient(cm);
        HttpClientUtil.configureClient(httpClient, config);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureClient(DefaultHttpClient httpClient, SolrParams config) {
        configurer.configure(httpClient, config);
        List<HttpRequestInterceptor> list = interceptors;
        synchronized (list) {
            for (HttpRequestInterceptor interceptor : interceptors) {
                httpClient.addRequestInterceptor(interceptor);
            }
        }
    }

    public static void close(HttpClient httpClient) {
        if (httpClient instanceof CloseableHttpClient) {
            IOUtils.closeQuietly((CloseableHttpClient)httpClient);
        } else {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static void addRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.add(interceptor);
    }

    public static void removeRequestInterceptor(HttpRequestInterceptor interceptor) {
        interceptors.remove(interceptor);
    }

    public static void setAllowCompression(DefaultHttpClient httpClient, boolean allowCompression) {
        httpClient.removeRequestInterceptorByClass(UseCompressionRequestInterceptor.class);
        httpClient.removeResponseInterceptorByClass(UseCompressionResponseInterceptor.class);
        if (allowCompression) {
            httpClient.addRequestInterceptor(new UseCompressionRequestInterceptor());
            httpClient.addResponseInterceptor(new UseCompressionResponseInterceptor());
        }
    }

    public static void setBasicAuth(DefaultHttpClient httpClient, String basicAuthUser, String basicAuthPass) {
        if (basicAuthUser != null && basicAuthPass != null) {
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
        } else {
            httpClient.getCredentialsProvider().clear();
        }
    }

    public static void setMaxConnectionsPerHost(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        }
    }

    public static void setMaxConnections(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        }
    }

    public static void setSoTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setSoTimeout(httpClient.getParams(), timeout);
    }

    public static void setUseRetry(DefaultHttpClient httpClient, boolean useRetry) {
        if (!useRetry) {
            httpClient.setHttpRequestRetryHandler(NO_RETRY);
        } else {
            httpClient.setHttpRequestRetryHandler(new SolrHttpRequestRetryHandler(3));
        }
    }

    public static void setConnectionTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setConnectionTimeout(httpClient.getParams(), timeout);
    }

    public static void setFollowRedirects(HttpClient httpClient, boolean followRedirects) {
        new ClientParamBean(httpClient.getParams()).setHandleRedirects(followRedirects);
    }

    public static void setHostNameVerifier(DefaultHttpClient httpClient, X509HostnameVerifier hostNameVerifier) {
        Scheme httpsScheme = httpClient.getConnectionManager().getSchemeRegistry().get("https");
        if (httpsScheme != null) {
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)httpsScheme.getSchemeSocketFactory();
            sslSocketFactory.setHostnameVerifier(hostNameVerifier);
        }
    }

    public static void setStaleCheckingEnabled(HttpClient httpClient, boolean enabled) {
        HttpConnectionParams.setStaleCheckingEnabled(httpClient.getParams(), enabled);
    }

    public static void setTcpNoDelay(HttpClient httpClient, boolean tcpNoDelay) {
        HttpConnectionParams.setTcpNoDelay(httpClient.getParams(), tcpNoDelay);
    }

    public static class HttpClientFactory {
        private static Class<? extends DefaultHttpClient> defaultHttpClientClass = DefaultHttpClient.class;
        private static Class<? extends SystemDefaultHttpClient> systemDefaultHttpClientClass = SystemDefaultHttpClient.class;

        public static SystemDefaultHttpClient createHttpClient() {
            try {
                Constructor<? extends SystemDefaultHttpClient> constructor = systemDefaultHttpClientClass.getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create HttpClient instance. ", (Throwable)e);
            }
        }

        public static DefaultHttpClient createHttpClient(ClientConnectionManager cm) {
            try {
                Constructor<? extends DefaultHttpClient> constructor = defaultHttpClientClass.getDeclaredConstructor(ClientConnectionManager.class);
                return constructor.newInstance(cm);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create HttpClient instance, registered class is: " + defaultHttpClientClass, (Throwable)e);
            }
        }

        public static void setHttpClientImpl(Class<? extends DefaultHttpClient> defaultHttpClient, Class<? extends SystemDefaultHttpClient> systemDefaultHttpClient) {
            defaultHttpClientClass = defaultHttpClient;
            systemDefaultHttpClientClass = systemDefaultHttpClient;
        }
    }

    private static class DeflateDecompressingEntity
    extends GzipDecompressingEntity {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new InflaterInputStream(this.wrappedEntity.getContent());
        }
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        @Override
        public long getContentLength() {
            return -1L;
        }
    }

    private static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        private UseCompressionResponseInterceptor() {
        }

        @Override
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        private UseCompressionRequestInterceptor() {
        }

        @Override
        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }
}

