/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String ELECTION_NODE = "/election";
    public static final Pattern LEADER_SEQ = Pattern.compile(".*?/?.*?-n_(\\d+)");
    private static final Pattern SESSION_ID = Pattern.compile(".*?/?(.*?-.*?)-n_\\d+");
    private static final Pattern NODE_NAME = Pattern.compile(".*?/?(.*?-)(.*?)-n_\\d+");
    protected SolrZkClient zkClient;
    private ZkCmdExecutor zkCmdExecutor;
    private volatile ElectionContext context;
    private ElectionWatcher watcher;
    private Map<ZkController.ContextKey, ElectionContext> electionContexts;
    private ZkController.ContextKey contextKey;

    public LeaderElector(SolrZkClient zkClient) {
        this.zkClient = zkClient;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
    }

    public LeaderElector(SolrZkClient zkClient, ZkController.ContextKey key, Map<ZkController.ContextKey, ElectionContext> electionContexts) {
        this.zkClient = zkClient;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
        this.electionContexts = electionContexts;
        this.contextKey = key;
    }

    public ElectionContext getContext() {
        return this.context;
    }

    private void checkIfIamLeader(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        context.checkIfIamLeaderFired();
        String holdElectionPath = context.electionPath + ELECTION_NODE;
        List<String> seqs = this.zkClient.getChildren(holdElectionPath, null, true);
        LeaderElector.sortSeqs(seqs);
        String leaderSeqNodeName = context.leaderSeqPath.substring(context.leaderSeqPath.lastIndexOf(47) + 1);
        if (!seqs.contains(leaderSeqNodeName)) {
            log.warn("Our node is no longer in line to be leader");
            return;
        }
        String prefix = this.zkClient.getSolrZooKeeper().getSessionId() + "-" + context.id + "-";
        Iterator<String> it = seqs.iterator();
        while (it.hasNext()) {
            String elec = it.next();
            if (elec.equals(leaderSeqNodeName) || !elec.startsWith(prefix)) continue;
            try {
                String toDelete = holdElectionPath + "/" + elec;
                log.warn("Deleting duplicate registration: {}", (Object)toDelete);
                this.zkClient.delete(toDelete, -1, true);
            }
            catch (KeeperException.NoNodeException toDelete) {
                // empty catch block
            }
            it.remove();
        }
        if (leaderSeqNodeName.equals(seqs.get(0))) {
            try {
                this.runIamLeaderProcess(context, replacement);
            }
            catch (KeeperException.NodeExistsException e) {
                log.error("node exists", (Throwable)e);
                this.retryElection(context, false);
                return;
            }
        }
        String toWatch = seqs.get(0);
        for (String node : seqs) {
            if (leaderSeqNodeName.equals(node)) break;
            toWatch = node;
        }
        try {
            String watchedNode = holdElectionPath + "/" + toWatch;
            this.watcher = new ElectionWatcher(context.leaderSeqPath, watchedNode, LeaderElector.getSeq(context.leaderSeqPath), context);
            this.zkClient.getData(watchedNode, this.watcher, null, true);
            log.info("Watching path {} to know if I could be the leader", (Object)watchedNode);
        }
        catch (KeeperException.SessionExpiredException e) {
            throw e;
        }
        catch (KeeperException.NoNodeException e) {
            this.checkIfIamLeader(context, true);
        }
        catch (KeeperException e) {
            log.warn("Failed setting watch", (Throwable)e);
            this.checkIfIamLeader(context, true);
        }
    }

    protected void runIamLeaderProcess(ElectionContext context, boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        context.runLeaderProcess(weAreReplacement, 0);
    }

    public static int getSeq(String nStringSequence) {
        int seq = 0;
        Matcher m = LEADER_SEQ.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        seq = Integer.parseInt(m.group(1));
        return seq;
    }

    private String getNodeId(String nStringSequence) {
        Matcher m = SESSION_ID.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String id = m.group(1);
        return id;
    }

    public static String getNodeName(String nStringSequence) {
        Matcher m = NODE_NAME.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String result = m.group(2);
        return result;
    }

    public int joinElection(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        return this.joinElection(context, replacement, false);
    }

    public int joinElection(ElectionContext context, boolean replacement, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        context.joinedElectionFired();
        String shardsElectZkPath = context.electionPath + ELECTION_NODE;
        long sessionId = this.zkClient.getSolrZooKeeper().getSessionId();
        String id = sessionId + "-" + context.id;
        String leaderSeqPath = null;
        boolean cont = true;
        int tries = 0;
        while (cont) {
            try {
                if (joinAtHead) {
                    log.info("Node {} trying to join election at the head", (Object)id);
                    List<String> nodes = OverseerTaskProcessor.getSortedElectionNodes(this.zkClient, shardsElectZkPath);
                    if (nodes.size() < 2) {
                        leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                    } else {
                        String firstInLine = nodes.get(1);
                        log.info("The current head: {}", (Object)firstInLine);
                        Matcher m = LEADER_SEQ.matcher(firstInLine);
                        if (!m.matches()) {
                            throw new IllegalStateException("Could not find regex match in:" + firstInLine);
                        }
                        leaderSeqPath = shardsElectZkPath + "/" + id + "-n_" + m.group(1);
                        this.zkClient.create(leaderSeqPath, null, CreateMode.EPHEMERAL, false);
                    }
                } else {
                    leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                }
                log.info("Joined leadership election with path: {}", (Object)leaderSeqPath);
                context.leaderSeqPath = leaderSeqPath;
                cont = false;
            }
            catch (KeeperException.ConnectionLossException e) {
                List<String> entries = this.zkClient.getChildren(shardsElectZkPath, null, true);
                boolean foundId = false;
                for (String entry : entries) {
                    String nodeId = this.getNodeId(entry);
                    if (!id.equals(nodeId)) continue;
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                cont = true;
                if (tries++ > 20) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (tries++ > 20) {
                    context = null;
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                cont = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.checkIfIamLeader(context, replacement);
        return LeaderElector.getSeq(context.leaderSeqPath);
    }

    public void setup(ElectionContext context) throws InterruptedException, KeeperException {
        String electZKPath = context.electionPath + ELECTION_NODE;
        this.zkCmdExecutor.ensureExists(electZKPath, this.zkClient);
        this.context = context;
    }

    public static void sortSeqs(List<String> seqs) {
        Collections.sort(seqs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i = LeaderElector.getSeq(o1) - LeaderElector.getSeq(o2);
                return i == 0 ? o1.compareTo(o2) : i;
            }
        });
    }

    void retryElection(ElectionContext context, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        ElectionWatcher watcher = this.watcher;
        ElectionContext ctx = context.copy();
        if (this.electionContexts != null) {
            this.electionContexts.put(this.contextKey, ctx);
        }
        if (watcher != null) {
            watcher.cancel();
        }
        this.context.cancelElection();
        this.context = ctx;
        this.joinElection(ctx, true, joinAtHead);
    }

    private class ElectionWatcher
    implements Watcher {
        final String myNode;
        final String watchedNode;
        final ElectionContext context;
        private boolean canceled = false;

        private ElectionWatcher(String myNode, String watchedNode, int seq, ElectionContext context) {
            this.myNode = myNode;
            this.watchedNode = watchedNode;
            this.context = context;
        }

        void cancel() {
            this.canceled = true;
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (this.canceled) {
                log.info("This watcher is not active anymore {}", (Object)this.myNode);
                try {
                    LeaderElector.this.zkClient.delete(this.myNode, -1, true);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                }
                catch (Exception e) {
                    log.warn("My watched node still exists and can't remove " + this.myNode, (Throwable)e);
                }
                return;
            }
            try {
                LeaderElector.this.checkIfIamLeader(this.context, true);
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
    }
}

