/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.RetryUtil;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardLeaderElectionContextBase
extends ElectionContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrZkClient zkClient;
    protected String shardId;
    protected String collection;
    protected LeaderElector leaderElector;
    private Integer leaderZkNodeParentVersion;
    private final Object lock = new Object();

    public ShardLeaderElectionContextBase(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkStateReader zkStateReader) {
        super(coreNodeName, "/collections/" + collection + "/leader_elect/" + shardId, ZkStateReader.getShardLeadersPath(collection, shardId), props, zkStateReader.getZkClient());
        this.leaderElector = leaderElector;
        this.zkClient = zkStateReader.getZkClient();
        this.shardId = shardId;
        this.collection = collection;
        try {
            new ZkCmdExecutor(zkStateReader.getZkClient().getZkClientTimeout()).ensureExists("/collections/" + collection, this.zkClient);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        super.cancelElection();
        Object object = this.lock;
        synchronized (object) {
            if (this.leaderZkNodeParentVersion != null) {
                try {
                    log.info("Removing leader registration node on cancel: {} {}", (Object)this.leaderPath, (Object)this.leaderZkNodeParentVersion);
                    ArrayList<Op> ops = new ArrayList<Op>(2);
                    ops.add(Op.check(new Path(this.leaderPath).getParent().toString(), this.leaderZkNodeParentVersion));
                    ops.add(Op.delete(this.leaderPath, -1));
                    this.zkClient.multi(ops, true);
                }
                catch (KeeperException.NoNodeException nne) {
                    log.info("No leader registration node found to remove: {}", (Object)this.leaderPath);
                }
                catch (KeeperException.BadVersionException bve) {
                    log.info("Cannot remove leader registration node because the current registered node is not ours: {}", (Object)this.leaderPath);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    SolrException.log(log, e);
                }
                this.leaderZkNodeParentVersion = null;
            } else {
                log.info("No version found for ephemeral leader parent node, won't remove previous leader registration.");
            }
        }
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStartMs) throws KeeperException, InterruptedException, IOException {
        final String parent = new Path(this.leaderPath).getParent().toString();
        ZkCmdExecutor zcmd = new ZkCmdExecutor(30000);
        zcmd.ensureExists(parent, this.zkClient);
        byte[] json = Utils.toJSON(this.leaderProps);
        try {
            RetryUtil.retryOnThrowable(KeeperException.NodeExistsException.class, 60000L, 5000L, new RetryUtil.RetryCmd(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() throws InterruptedException, KeeperException {
                    Object object = ShardLeaderElectionContextBase.this.lock;
                    synchronized (object) {
                        log.info("Creating leader registration node {} after winning as {}", (Object)ShardLeaderElectionContextBase.this.leaderPath, (Object)ShardLeaderElectionContextBase.this.leaderSeqPath);
                        ArrayList<Op> ops = new ArrayList<Op>(2);
                        ops.add(Op.check(ShardLeaderElectionContextBase.this.leaderSeqPath, -1));
                        ops.add(Op.create(ShardLeaderElectionContextBase.this.leaderPath, Utils.toJSON(ShardLeaderElectionContextBase.this.leaderProps), ShardLeaderElectionContextBase.this.zkClient.getZkACLProvider().getACLsToAdd(ShardLeaderElectionContextBase.this.leaderPath), CreateMode.EPHEMERAL));
                        ops.add(Op.setData(parent, null, -1));
                        List<OpResult> results = ShardLeaderElectionContextBase.this.zkClient.multi(ops, true);
                        for (OpResult result : results) {
                            if (result.getType() != 5) continue;
                            OpResult.SetDataResult dresult = (OpResult.SetDataResult)result;
                            Stat stat = dresult.getStat();
                            ShardLeaderElectionContextBase.this.leaderZkNodeParentVersion = stat.getVersion();
                            return;
                        }
                        assert (ShardLeaderElectionContextBase.this.leaderZkNodeParentVersion != null);
                    }
                }
            });
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not register as the leader because creating the ephemeral registration node in ZooKeeper failed", t);
        }
        assert (this.shardId != null);
        ZkNodeProps m = ZkNodeProps.fromKeyVals("operation", OverseerAction.LEADER.toLower(), "shard", this.shardId, "collection", this.collection, "base_url", this.leaderProps.getProperties().get("base_url"), "core", this.leaderProps.getProperties().get("core"), "state", Replica.State.ACTIVE.toString());
        Overseer.getInQueue(this.zkClient).offer(Utils.toJSON(m));
    }

    public LeaderElector getLeaderElector() {
        return this.leaderElector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getLeaderZkNodeParentVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.leaderZkNodeParentVersion;
        }
    }
}

