/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class SolrZooKeeper
extends ZooKeeper {
    final Set<Thread> spawnedThreads = new CopyOnWriteArraySet<Thread>();

    public SolrZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        super(connectString, sessionTimeout, watcher);
    }

    public ClientCnxn getConnection() {
        return this.cnxn;
    }

    public SocketAddress getSocketAddress() {
        return this.testableLocalSocketAddress();
    }

    public void closeCnxn() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            return this.closeZookeeperChannel();
                        }
                    });
                }
                finally {
                    SolrZooKeeper.this.spawnedThreads.remove(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressForbidden(reason="Hack for Zookeper needs access to private methods.")
            Void closeZookeeperChannel() {
                ClientCnxn cnxn;
                ClientCnxn clientCnxn = cnxn = SolrZooKeeper.this.getConnection();
                synchronized (clientCnxn) {
                    try {
                        Field sendThreadFld = cnxn.getClass().getDeclaredField("sendThread");
                        sendThreadFld.setAccessible(true);
                        Object sendThread = sendThreadFld.get(cnxn);
                        if (sendThread != null) {
                            Method method = sendThread.getClass().getDeclaredMethod("testableCloseSocket", new Class[0]);
                            method.setAccessible(true);
                            try {
                                method.invoke(sendThread, new Object[0]);
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Closing Zookeeper send channel failed.", e);
                    }
                }
                return null;
            }
        };
        this.spawnedThreads.add(t);
        t.start();
    }

    @Override
    public synchronized void close() throws InterruptedException {
        for (Thread t : this.spawnedThreads) {
            if (!t.isAlive()) continue;
            t.interrupt();
        }
        super.close();
    }
}

