/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RunExecutableListener
extends AbstractSolrEventListener
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ENABLED_ARG = "solr.enableRunExecutableListener";
    private static final String WARNING_MESSAGE = String.format(Locale.ENGLISH, "RunExecutableListener is deprecated and disabled by default for security reasons. Legacy applications still using it must explicitely pass '-D%s=true' to the Solr command line. Be aware that you should really disable API-based config editing at the same time, using '-D%s=true'!", "solr.enableRunExecutableListener", "disable.configEdit");
    private static final boolean enabled = Boolean.getBoolean("solr.enableRunExecutableListener");
    protected String[] cmd;
    protected File dir;
    protected String[] envp;
    protected boolean wait = true;
    private static int INVALID_PROCESS_RETURN_CODE = -1;

    public RunExecutableListener(SolrCore core) {
        super(core);
    }

    @Override
    public void init(NamedList args) {
        String str;
        super.init(args);
        ArrayList cmdlist = new ArrayList();
        cmdlist.add(args.get("exe"));
        List lst = (List)args.get("args");
        if (lst != null) {
            cmdlist.addAll(lst);
        }
        this.cmd = cmdlist.toArray(new String[cmdlist.size()]);
        lst = (List)args.get("env");
        if (lst != null) {
            this.envp = lst.toArray(new String[lst.size()]);
        }
        this.dir = (str = (String)args.get("dir")) == null || str.equals("") || str.equals(".") || str.equals("./") ? null : new File(str);
        if ("false".equals(args.get("wait")) || Boolean.FALSE.equals(args.get("wait"))) {
            this.wait = false;
        }
    }

    @Override
    public void inform(SolrCore core) {
        log.warn(WARNING_MESSAGE);
    }

    protected int exec(String callback) {
        if (!enabled) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, WARNING_MESSAGE);
        }
        int ret = 0;
        try {
            Process proc;
            boolean doLog = log.isDebugEnabled();
            if (doLog) {
                log.debug("About to exec " + this.cmd[0]);
            }
            try {
                proc = Runtime.getRuntime().exec(this.cmd, this.envp, this.dir);
            }
            catch (Error err) {
                if (err.getMessage() != null && (err.getMessage().contains("posix_spawn") || err.getMessage().contains("UNIXProcess"))) {
                    Error newErr = new Error("Error forking command due to JVM locale bug (see https://issues.apache.org/jira/browse/SOLR-6387): " + err.getMessage());
                    newErr.setStackTrace(err.getStackTrace());
                    err = newErr;
                }
                throw err;
            }
            if (this.wait) {
                try {
                    ret = proc.waitFor();
                }
                catch (InterruptedException e) {
                    SolrException.log(log, e);
                    ret = INVALID_PROCESS_RETURN_CODE;
                }
            }
            if (this.wait && doLog) {
                log.debug("Executable " + this.cmd[0] + " returned " + ret);
            }
        }
        catch (IOException e) {
            SolrException.log(log, e);
            ret = INVALID_PROCESS_RETURN_CODE;
        }
        return ret;
    }

    @Override
    public void postCommit() {
        this.exec("postCommit");
    }

    @Override
    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        this.exec("newSearcher");
    }
}

