/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.NestedRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.stats.Snapshot;
import org.apache.solr.util.stats.Timer;
import org.apache.solr.util.stats.TimerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerBase
implements SolrRequestHandler,
SolrInfoMBean,
NestedRequestHandler {
    protected NamedList initArgs = null;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    protected boolean httpCaching = true;
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong numErrors = new AtomicLong();
    private final AtomicLong numTimeouts = new AtomicLong();
    private final Timer requestTimes = new Timer();
    private final long handlerStart = System.currentTimeMillis();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PluginInfo pluginInfo;

    @SuppressForbidden(reason="Need currentTimeMillis, used only for stats output")
    public RequestHandlerBase() {
    }

    @Override
    public void init(NamedList args) {
        this.initArgs = args;
        if (args != null) {
            Object o = args.get("defaults");
            if (o != null && o instanceof NamedList) {
                this.defaults = SolrParams.toSolrParams((NamedList)o);
            }
            if ((o = args.get("appends")) != null && o instanceof NamedList) {
                this.appends = SolrParams.toSolrParams((NamedList)o);
            }
            if ((o = args.get("invariants")) != null && o instanceof NamedList) {
                this.invariants = SolrParams.toSolrParams((NamedList)o);
            }
        }
        if (this.initArgs != null) {
            Object caching = this.initArgs.get("httpCaching");
            this.httpCaching = caching != null ? Boolean.parseBoolean(caching.toString()) : true;
        }
    }

    public NamedList getInitArgs() {
        return this.initArgs;
    }

    public abstract void handleRequestBody(SolrQueryRequest var1, SolrQueryResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.numRequests.incrementAndGet();
        TimerContext timer = this.requestTimes.time();
        try {
            if (this.pluginInfo != null && this.pluginInfo.attributes.containsKey("useParams")) {
                req.getContext().put("useParams", this.pluginInfo.attributes.get("useParams"));
            }
            SolrPluginUtils.setDefaults(this, req, this.defaults, this.appends, this.invariants);
            req.getContext().remove("useParams");
            rsp.setHttpCaching(this.httpCaching);
            this.handleRequestBody(req, rsp);
            NamedList<Object> header = rsp.getResponseHeader();
            if (header != null) {
                boolean timedOut;
                Object partialResults = header.get("partialResults");
                boolean bl = timedOut = partialResults == null ? false : (Boolean)partialResults;
                if (timedOut) {
                    this.numTimeouts.incrementAndGet();
                    rsp.setHttpCaching(false);
                }
            }
        }
        catch (Exception e2) {
            SolrException e2;
            if (e2 instanceof SolrException) {
                SolrException se = (SolrException)e2;
                if (se.code() != SolrException.ErrorCode.CONFLICT.code) {
                    SolrException.log(log, e2);
                }
            } else {
                SolrException.log(log, e2);
                if (e2 instanceof SyntaxError) {
                    e2 = new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e2);
                }
            }
            rsp.setException(e2);
            this.numErrors.incrementAndGet();
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERYHANDLER;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return null;
    }

    public static SolrRequestHandler getRequestHandler(String handlerName, PluginBag<SolrRequestHandler> reqHandlers) {
        if (handlerName == null) {
            return null;
        }
        SolrRequestHandler handler = reqHandlers.get(handlerName);
        int idx = 0;
        if (handler == null) {
            while ((idx = handlerName.indexOf(47, idx + 1)) > 0) {
                String firstPart = handlerName.substring(0, idx);
                handler = reqHandlers.get(firstPart);
                if (handler == null || !(handler instanceof NestedRequestHandler)) continue;
                return ((NestedRequestHandler)((Object)handler)).getSubHandler(handlerName.substring(idx));
            }
        }
        return handler;
    }

    public void setPluginInfo(PluginInfo pluginInfo) {
        if (this.pluginInfo == null) {
            this.pluginInfo = pluginInfo;
        }
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public NamedList<Object> getStatistics() {
        SimpleOrderedMap<Object> lst = new SimpleOrderedMap<Object>();
        Snapshot snapshot = this.requestTimes.getSnapshot();
        lst.add("handlerStart", this.handlerStart);
        lst.add("requests", this.numRequests.longValue());
        lst.add("errors", this.numErrors.longValue());
        lst.add("timeouts", this.numTimeouts.longValue());
        lst.add("totalTime", this.requestTimes.getSum());
        lst.add("avgRequestsPerSecond", this.requestTimes.getMeanRate());
        lst.add("5minRateReqsPerSecond", this.requestTimes.getFiveMinuteRate());
        lst.add("15minRateReqsPerSecond", this.requestTimes.getFifteenMinuteRate());
        lst.add("avgTimePerRequest", this.requestTimes.getMean());
        lst.add("medianRequestTime", snapshot.getMedian());
        lst.add("75thPcRequestTime", snapshot.get75thPercentile());
        lst.add("95thPcRequestTime", snapshot.get95thPercentile());
        lst.add("99thPcRequestTime", snapshot.get99thPercentile());
        lst.add("999thPcRequestTime", snapshot.get999thPercentile());
        return lst;
    }
}

